% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loaders-dependencies.R, R/loaders-handler.R
\name{useLoaders}
\alias{useLoaders}
\alias{loaders}
\title{CSS Loaders}
\usage{
useLoaders()

loaders(uiOutput, type = "default", style = NULL, text = NULL)
}
\arguments{
\item{uiOutput}{An output element to be wrapped within a loader.}

\item{type}{The type of loader to use. Visit \url{https://css-loader.raphaelfabeni.com/} for details.
\itemize{
\item default
\item bar
\item bar-ping-pong
\item border
\item double
\item clock
\item curtain
\item pokeball
\item ball
\item smartphone
\item bouncing
\item music
}}

\item{style}{Custom styling for the loaders.}

\item{text}{Custom text. Available only for the following types:
\itemize{
\item default
\item bar
\item border
\item curtain
\item smartphone
}}
}
\value{
None
}
\description{
Simple CSS loaders
}
\section{Functions}{

\itemize{
\item \code{useLoaders}: Dependencies to include in your UI.
\item \code{loaders}: Display loading animation.
}
}

\examples{
if (interactive()) {
  library(shiny)

  shinyApp(
    ui = fluidPage(
      useLoaders(),
      actionButton("render", "Render"),
      loaders(uiOutput = plotOutput("plot"),
              type = "default",
              style = "half",
              text = "Loading...")
    ),
    server = function(input, output) {
      output$plot <- renderPlot({
        input$render
        Sys.sleep(3)
        hist(mtcars$mpg)
      })
    }
  )
}

}
