% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers_catboost.R
\name{catboost_train}
\alias{catboost_train}
\title{Train the model}
\usage{
catboost_train(learn_pool, test_pool = NULL, params = list())
}
\arguments{
\item{learn_pool}{Training dataset.}

\item{test_pool}{Testing dataset.}

\item{params}{A list of training parameters.}
}
\value{
A model object.
}
\description{
Train the model
}
\examples{
\dontshow{if (is_installed_catboost()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
sim_data <- msaenet::msaenet.sim.binomial(
  n = 100,
  p = 10,
  rho = 0.6,
  coef = rnorm(5, mean = 0, sd = 10),
  snr = 1,
  p.train = 0.8,
  seed = 42
)

x_train <- catboost_load_pool(data = sim_data$x.tr, label = sim_data$y.tr)

fit <- catboost_train(
  x_train,
  NULL,
  params = list(
    loss_function = "Logloss",
    iterations = 100,
    depth = 3,
    logging_level = "Silent"
  )
)

fit
\dontshow{\}) # examplesIf}
}
