% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csiro_nickel_fresh.R
\docType{data}
\name{csiro_nickel_fresh}
\alias{csiro_nickel_fresh}
\title{Species Sensitivity Data for nickel_fresh}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl},
\code{data.frame}) with 31 rows and 6 columns.
}
\usage{
csiro_nickel_fresh
}
\description{
Species Sensitivity Data provided by the Commonwealth Scientific and
Industrial Research Organisation of Australia for nickel in fresh water.
}
\details{
These data were sourced from:
\insertRef{Stauber2021}{ssddata}

The columns are as follows:

\describe{
\item{Conc}{The chemical concentration (dbl).}
\item{Domain}{Tropical, temperate or other filter (chr).}
\item{Group}{Taxonomic grouping information (chr).}
\item{Notes}{Other notes (chr).}
\item{Species}{The species names name (chr).}
\item{Test_endpoint}{Endpoint statistic, EC10, NEC etc (chr).}

Where toxicity measure is not a chronic NEC, EC10 or NOEC value,
concentration has been converted using the appropriate default ratio, as
follows: 10 from acute EC50/LC50 to chronic EC10; 5 from chronic EC50 to
EC10; 2.5 from LOEC to EC10. Please see the primary reference material for
more information.

All concentration data are ug/L unless otherwise stated. }
}
\examples{

print(csiro_nickel_fresh, n=Inf)

}
\keyword{datasets}
