#' Extract SQUIDs from a character vector
#'
#' This function simply looks for matches with
#'
#' @param x The character vector
#'
#' @returns A character vector with SQUIDs
#' @export
#'
#' @examples example <-
#'   paste0(
#'     "some prefix text ", 1:5, " ",
#'     squids::squids(5),
#'     " ", letters[1:5], " some suffix text"
#'   );
#'
#' squids::extract_squids(
#'   example
#' );
extract_squids <- function(x) {

  res <-
    regmatches(
      x,
      regexpr(
        "([0123456789bcdfghjklmnpqrstwxyz]{8})",
        x,
        perl = TRUE
      )
    )

  return(res);

}
