% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StmtLimit.R
\name{StmtLimit}
\alias{StmtLimit}
\title{LIMIT statement.}
\description{
LIMIT statement.

LIMIT statement.
}
\details{
This class represents a SQL LIMIT statement. It requires a single
integer limit value.
}
\examples{
# Create a LIMIT statement with a limit of 10:
limit <- StmtLimit$new(10L)

# Use the created LIMIT statement inside a SELECT query:
query <- QuerySelect$new(StmtSelectAll$new(),
                         from = StmtFrom$new("books"))
query$add(limit)

}
\section{Super class}{
\code{\link[sqlq:Statement]{sqlq::Statement}} -> \code{StmtLimit}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-StmtLimit-new}{\code{StmtLimit$new()}}
\item \href{#method-StmtLimit-getTokens}{\code{StmtLimit$getTokens()}}
\item \href{#method-StmtLimit-clone}{\code{StmtLimit$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="sqlq" data-topic="Statement" data-id="toString"><a href='../../sqlq/html/Statement.html#method-Statement-toString'><code>sqlq::Statement$toString()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StmtLimit-new"></a>}}
\if{latex}{\out{\hypertarget{method-StmtLimit-new}{}}}
\subsection{Method \code{new()}}{
Initializer
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StmtLimit$new(limit)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{limit}}{The integer limit.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StmtLimit-getTokens"></a>}}
\if{latex}{\out{\hypertarget{method-StmtLimit-getTokens}{}}}
\subsection{Method \code{getTokens()}}{
Generates the list of tokens representing this statement.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StmtLimit$getTokens()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of Token objects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StmtLimit-clone"></a>}}
\if{latex}{\out{\hypertarget{method-StmtLimit-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StmtLimit$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
