% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QueryUpdate.R
\name{QueryUpdate}
\alias{QueryUpdate}
\title{Update Query.}
\description{
Update Query.

Update Query.
}
\details{
This class represents an SQL UPDATE query.
See the make_update() factory function to create more easily an UPDATE query
object.
}
\examples{
# To generate a simple UPDATE query:
where <- StmtWhere$new(ExprBinOp$new(
  ExprField$new("year"), "<",
  ExprValue$new(2010)
))
set <- make_set(price = 9.50, old = TRUE)
update <- QueryUpdate$new(StmtUpdate$new('books'), set = set)
update$add(where)

}
\seealso{
\code{\link{make_update}}
}
\section{Super class}{
\code{\link[sqlq:Query]{sqlq::Query}} -> \code{QueryUpdate}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-QueryUpdate-new}{\code{QueryUpdate$new()}}
\item \href{#method-QueryUpdate-clone}{\code{QueryUpdate$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="sqlq" data-topic="Query" data-id="add"><a href='../../sqlq/html/Query.html#method-Query-add'><code>sqlq::Query$add()</code></a></span></li>
<li><span class="pkg-link" data-pkg="sqlq" data-topic="Query" data-id="toString"><a href='../../sqlq/html/Query.html#method-Query-toString'><code>sqlq::Query$toString()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-QueryUpdate-new"></a>}}
\if{latex}{\out{\hypertarget{method-QueryUpdate-new}{}}}
\subsection{Method \code{new()}}{
Initializer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QueryUpdate$new(up, set)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{up}}{A StmtUpdate instance.}

\item{\code{set}}{A StmtSet instance.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-QueryUpdate-clone"></a>}}
\if{latex}{\out{\hypertarget{method-QueryUpdate-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QueryUpdate$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
