% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{estcovparm}
\alias{estcovparm}
\title{Estimate Covariance Parameters}
\usage{
estcovparm(
  response,
  designmatrix,
  xcoordsvec,
  ycoordsvec,
  CorModel = "Exponential",
  estmethod = "REML",
  covestimates = c(NA, NA, NA)
)
}
\arguments{
\item{response}{a vector of a response variable, possibly with
missing values.}

\item{designmatrix}{is the matrix of covariates used to regress
the response on.}

\item{xcoordsvec}{is a vector of x coordinates}

\item{ycoordsvec}{is a vector of y coordinates}

\item{CorModel}{is the covariance structure. By default,
\code{CorModel} is \code{"Exponential"} but other options are
\code{"Spherical"} and \code{"Gaussian"}.}

\item{estmethod}{is either the default \code{"REML"} for restricted
maximum likelihood to estimate the covariance parameters and
regression coefficients or \code{"ML"} to estimate the covariance
parameters and regression coefficients.}

\item{covestimates}{is an optional vector of covariance parameter estimates (nugget, partial sill, range). If these are given and \code{estmethod = "None"}, the the provided vector are treated as the estimators to create the covariance structure.}
}
\value{
a list with \itemize{
   \item \code{parms.est}, a vector of estimated covariance parameters
   \item \code{Sigma}, the fitted covariance matrix for all of the sites
   \item \code{qrV}, the qr decomposition
   \item \code{b.hat}, the vector of estimated fixed effect coefficients
   \item \code{covbi}, the inverse of the covariance matrix for the fixed effects
   \item \code{covb}, the covariance matrix for the fixed effects
   \item \code{min2loglik}, minus two times the loglikelihood
}
}
\description{
Used to estimate spatial covariance parameters for a few different spatial models.
Estimated parameters can then be used in \code{predict.slmfit()} to predict values at unobserved locations.
}
\details{
The function is a helper function used internally in \code{predict.slmfit()}.
}
\keyword{internal}
