% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_track_audio_features.R
\name{get_track_audio_features}
\alias{get_track_audio_features}
\title{Gets audio features of a single track}
\usage{
get_track_audio_features(
  track_id,
  output = c("tidy", "raw"),
  limit = 20,
  offset = 0,
  token = my_token
)
}
\arguments{
\item{track_id}{Required. Expects a single track_id. Get Spotify Catalog information for this track_id.}

\item{output}{Type of output to return from the request. Default: tidy.}

\item{limit}{Maximum number of results to return. Should be between 1 and 50. Default: 20.}

\item{offset}{The index of the first result to return. Default: 0.}

\item{token}{A valid access token from the Spotify Accounts service: see
\url{https://developer.spotify.com/documentation/general/guides/authorization-guide/} for details. Default: my_token.}
}
\value{
Default: returns a tidy dataframe with a selection of the response. Alternatively, when output is set to raw, it returns the raw output from the
request.
}
\description{
Connects with the Spotify API and returns output from the href \url{https://api.spotify.com/v1/audio-features/{id}/}
}
