% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.idigbio.R
\name{as.idigbio}
\alias{as.idigbio}
\title{Coerce occurrence keys to idigbio objects}
\usage{
as.idigbio(x, ...)
}
\arguments{
\item{x}{Various inputs, including the output from a call to \code{\link[=occ]{occ()}}
(class occdat), \code{\link[=occ2df]{occ2df()}} (class data.frame), or a list, numeric,
character, idigbiokey, or occkey.}

\item{...}{curl options; named parameters passed on to \code{httr::GET()}}
}
\value{
One or more in a list of both class idigbiokey and occkey
}
\description{
Coerce occurrence keys to idigbio objects
}
\details{
Internally, we use \code{\link[ridigbio]{idig_view_records}}, whereas we use
\code{\link[ridigbio]{idig_search_records}} in the \code{\link[=occ]{occ()}} function.
}
\examples{
\dontrun{
spnames <- c('Accipiter striatus', 'Setophaga caerulescens',
  'Spinus tristis')
out <- occ(query=spnames, from='idigbio', limit=2)
res <- occ2df(out)
(tt <- as.idigbio(out))
(uu <- as.idigbio(res))
as.idigbio(res$key[1])
as.idigbio(as.list(res$key[1:2]))
as.idigbio(tt[[1]])
as.idigbio(uu[[1]])
as.idigbio(tt[1:2])

library("dplyr")
bind_rows(lapply(tt, function(x) data.frame(unclass(x)$data)))
}
}
\seealso{
Other coercion: 
\code{\link{as.ala}()},
\code{\link{as.gbif}()},
\code{\link{as.inat}()},
\code{\link{as.obis}()},
\code{\link{as.vertnet}()}
}
\concept{coercion}
