% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spicy_tables.R
\name{spicy_tables}
\alias{spicy_tables}
\title{Spicy Table Engine: Frequency and Cross-tabulation Rendering}
\description{
The \emph{spicy table engine} provides a cohesive set of tools for creating and
printing formatted ASCII tables in R, designed for descriptive statistics.

Functions in this family include:
\itemize{
\item \code{\link[=freq]{freq()}} — frequency tables with support for weights, labelled data, and cumulative percentages
\item \code{\link[=spicy_print_table]{spicy_print_table()}} — general-purpose ASCII table printer
\item \code{\link[=build_ascii_table]{build_ascii_table()}} — internal rendering engine for column alignment and formatting
}
}
\details{
All functions in this family share a common philosophy:
\itemize{
\item Console-friendly display with Unicode box-drawing characters
\item Consistent alignment and spacing across outputs
\item Automatic detection of variable type (\code{factor}, \code{labelled}, \code{numeric})
\item Optional integration of variable labels and weighting information
}
}
\section{Core functions}{

\itemize{
\item \strong{\code{freq()}} — Main entry point for generating frequency tables.
\item \strong{\code{spicy_print_table()}} — Applies formatting and optional titles or notes.
\item \strong{\code{build_ascii_table()}} — Internal engine handling padding, alignment, and box rules.
}
}

\section{Output styling}{

The spicy table engine supports multiple padding options via \code{padding}:
\code{"compact"} (default), \code{"normal"}, and \code{"wide"}.
Horizontal and vertical rules can be customized, and colors are supported
when the terminal allows ANSI color output (via the \strong{crayon} package).
}

\seealso{
\code{\link[=print.spicy_freq_table]{print.spicy_freq_table()}} for the specialized frequency display method.
\code{\link[labelled:to_factor]{labelled::to_factor()}} and \code{\link[dplyr:pull]{dplyr::pull()}} for data transformations.
}
\concept{spicy tables}
\keyword{descriptive}
\keyword{frequency}
\keyword{spicy}
\keyword{tables}
