% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec.R
\name{read.spec}
\alias{read.spec}
\title{Read Specification from File}
\usage{
read.spec(x, clean = TRUE, ...)
}
\arguments{
\item{x}{character (file path)}

\item{clean}{whether to strip balanced double quotes and outer white space from character values}

\item{...}{passed arguments (ignored)}
}
\value{
spec
}
\description{
Reads specification from file.  If first line contains tab characters, assumes format is tab-delimited text.  Otherwise, assumes format is comma-separated variable (csv).
}
\examples{
data(drug)
file <- tempfile()
spec <- specification(drug, tol = 3)
write.spec(spec, file = file)
read.spec(file)
}
\seealso{
Other as.spec: 
\code{\link{as.spec.character}()},
\code{\link{as.spec.data.frame}()},
\code{\link{as.spec}()},
\code{\link{write.spec}()}
}
\concept{as.spec}
