% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dgp.R
\name{make_x_bivariate}
\alias{make_x_bivariate}
\alias{make_x_uniform}
\alias{make_x_normal}
\alias{make_x}
\title{Simulate X variables}
\usage{
make_x_bivariate(n = 5, mu = 1, cor = 0.25, var = c(1, 1))

make_x_uniform(n = 5, var = 1)

make_x_normal(n = 5, mu = 0, var = 1)

make_x(
  n = 5,
  mu = 0,
  var = 1,
  cor = 0,
  method = c("uniform", "normal", "bivnormal")
)
}
\arguments{
\item{n}{the number of values to simulate.}

\item{mu}{the sample average.}

\item{cor}{correlation between bivariate normal}

\item{var}{the sample variance. The \code{sqrt(var)} is passed to \code{rnorm()} and \code{rlnorm()} for normal and laplace distributions.
\code{sqrt(var / 2)} is used for \code{laplace()} .}

\item{method}{must be one of \code{"uniform"} (default), \code{"normal"}, or \code{"bivnormal"} (bivariate normal).}
}
\value{
A \code{data.frame} of the simulated independent variables.
}
\description{
Simulates independent variables.
}
\examples{
make_x(10, mu = c(0.5, 1.2), var = c(1, 0.5)) 
}
