% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findFirstStudyRegionPoint.R
\name{findBASSeed}
\alias{findBASSeed}
\title{Randomly generates a point in the study region and maps it to the Halton Sequence.}
\usage{
findBASSeed(shapefile, bb, n = 1, verbose = FALSE)
}
\arguments{
\item{shapefile}{Shape file as a polygon (sp or sf) of the study area(s).}

\item{bb}{Bounding box which defines the sample. A bounding box must be
supplied and may not necessarily be the bounding box of the provided shape.}

\item{n}{Number of seeds to produce.}

\item{verbose}{Boolean if you want to see any output printed to screen. Helpful if taking a
long time. Default is FALSE i.e. no informational messages are displayed.}
}
\value{
A vector when n = 1 (Default), or a matrix when n > 1.
}
\description{
This function uses \code{sf::st_sample()} internally to generate a random point in the study region.
It then maps that point to the Halton Sequence to ensure that the random starting point is within the region.
That point is approximately mapped, and thus a check to make sure the new point is still within the study region is completed.
This function is used internally, but may useful for a user to generate multiple seeds in advance in a simulation study using BAS.
}
\author{
Paul van Dam-Bates
}
\keyword{internal}
