% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weights_from_distance_matrix.R
\name{weights_from_distance_matrix}
\alias{weights_from_distance_matrix}
\title{Transforms a distance matrix into a matrix of weights}
\usage{
weights_from_distance_matrix(
  distance.matrix = NULL,
  distance.threshold = 0
)
}
\arguments{
\item{distance.matrix}{Distance matrix. Default: \code{NULL}.}

\item{distance.threshold}{Numeric, positive, in the range of values of \code{distance.matrix}. Distances below this value in the distance matrix are set to 0., Default: \code{0}.}
}
\value{
A weighted distance matrix.
}
\description{
Transforms a distance matrix into weights (1/distance.matrix) normalized by the row sums. Used to compute Moran's I values and Moran's Eigenvector Maps. Allows to apply a threshold to the distance matrix before computing the weights.
}
\examples{

data(plants_distance)

y <- weights_from_distance_matrix(
  distance.matrix = plants_distance
)

y[1:5, 1:5]

}
\seealso{
Other preprocessing: 
\code{\link{auto_cor}()},
\code{\link{auto_vif}()},
\code{\link{case_weights}()},
\code{\link{default_distance_thresholds}()},
\code{\link{double_center_distance_matrix}()},
\code{\link{is_binary}()},
\code{\link{make_spatial_fold}()},
\code{\link{make_spatial_folds}()},
\code{\link{the_feature_engineer}()}
}
\concept{preprocessing}
