% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/munit_measure.R
\name{munit_measure}
\alias{munit_measure}
\alias{munit_measure-spatPomp}
\alias{munit_measure,spatPomp-method}
\title{Matching moments for the unit measurement model}
\usage{
\S4method{munit_measure}{spatPomp}(object, x, vc, unit, time, params, Np = 1)
}
\arguments{
\item{object}{An object of class \code{spatPomp}}

\item{x}{A state vector for all units}

\item{vc}{The empirically calculated variance used to perform moment-matching}

\item{unit}{The unit for which to obtain a moment-matched parameter set}

\item{time}{The time for which to obtain a moment-matched parameter set}

\item{params}{parameters to use to obtain a moment-matched parameter set}

\item{Np}{Number of particle replicates for which to get parameter sets}
}
\value{
An array with dimensions \code{dim(array.params)[1]} by \code{dim(x)[2]} by \code{length(unit)} by\code{length(time)}
representing the moment-matched parameter set(s) corresponding to the variance of the measurements, \code{vc}, and the states, \code{x}.
}
\description{
\code{munit_measure} returns a moment-matched parameter set given an empirically calculated measurement variance and latent states.
This is used in \code{girf()} and \code{igirf()} when they are run with \code{kind='moment'}.
}
\examples{
# Complete examples are provided in the package tests
\dontrun{
b <- bm(U=3)
s <- states(b)[,1,drop=FALSE]
rownames(s) -> rn
dim(s) <- c(3,1,1)
dimnames(s) <- list(variable=rn, rep=NULL)
p <- coef(b); names(p) -> rnp
dim(p) <- c(length(p),1); dimnames(p) <- list(param=rnp)
o <- obs(b)[,1,drop=FALSE]
array.params <- array(p,
                      dim = c(length(p),
                              length(unit_names(b)), 1, 1),
                      dimnames = list(params = rownames(p)))
vc <- c(4, 9, 16); dim(vc) <- c(length(vc), 1, 1)
munit_measure(b, x=s, vc=vc, Np=1, unit = 1, time=1, params=array.params)
}

}
\author{
Kidus Asfaw
}
