% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper-intercept.r
\name{no_intercept}
\alias{no_intercept}
\title{Removes the intercept term from a formula if it is included}
\usage{
no_intercept(formula, data)
}
\arguments{
\item{formula}{a model formula to remove its intercept term}

\item{data}{data frame}
}
\value{
formula with no intercept term
}
\description{
Often, we prefer not to have an intercept term in a model, but user-specified
formulas might have included the intercept term. In this case, we wish to
update the formula but without the intercept term. This is especially true in
numerous classification models, where errors and doom can occur if an
intercept is included in the model.
}
\examples{
iris_formula <- formula(Species ~ .)
no_intercept(iris_formula, data = iris)
}
