% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{subset_data}
\alias{subset_data}
\title{Function to subset data for meta-analysis}
\usage{
subset_data(data, K)
}
\arguments{
\item{data}{\link{list} three elements: first named \eqn{Y}, second named \eqn{X}, third named \eqn{crd}}

\item{K}{\link{integer} number of desired subsets}
}
\value{
\link{list} subsets of data, and the set of indexes
}
\description{
Function to subset data for meta-analysis
}
\examples{
## Create a list of K random subsets given a list with Y, X, and crd
n <- 100
p <- 3
q <- 2
X <- matrix(rnorm(n*p), nrow = n, ncol = p)
Y <- matrix(rnorm(n*q), nrow = n, ncol = q)
crd <- matrix(runif(n*2), nrow = n, ncol = 2)
subsets <- subset_data(data = list(Y = Y, X = X, crd = crd), K = 10)

}
