% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{BPS_PseudoBMA}
\alias{BPS_PseudoBMA}
\title{Combine subset models wiht Pseudo-BMA}
\usage{
BPS_PseudoBMA(fit_list)
}
\arguments{
\item{fit_list}{\link{list} K fitted model outputs composed by two elements each: first named \eqn{epd}, second named \eqn{W}}
}
\value{
\link{matrix} posterior predictive density evaluations (each columns represent a different model)
}
\description{
Combine subset models wiht Pseudo-BMA
}
\examples{
\donttest{
## Generate subsets of data
n <- 100
p <- 3
X <- matrix(rnorm(n*p), nrow = n, ncol = p)
Y <- matrix(rnorm(n), nrow = n, ncol = 1)
crd <- matrix(runif(n*2), nrow = n, ncol = 2)
data_part <- subset_data(data = list(Y = Y, X = X, crd = crd), K = 10)

## Select competitive set of values for hyperparameters
delta_seq <- c(0.1, 0.2, 0.3)
phi_seq <- c(3, 4, 5)

## Perform Bayesian Predictive Stacking within subsets
fit_list <- vector(length = 10, mode = "list")
for (i in 1:10) {
    Yi <- data_part$Y_list[[i]]
    Xi <- data_part$X_list[[i]]
    crd_i <- data_part$crd_list[[i]]
    p <- ncol(Xi)
    bps <- spBPS::BPS_weights(data = list(Y = Yi, X = Xi),
                               priors = list(mu_b = matrix(rep(0, p)),
                                             V_b = diag(10, p),
                                             a = 2,
                                             b = 2), coords = crd_i,
                                             hyperpar = list(delta = delta_seq,
                                                             phi = phi_seq),
                                             K = 5)
     w_hat <- bps$W
     epd <- bps$epd
     fit_list[[i]] <- list(epd, w_hat) }

## Combination weights between partitions using Pseudo Bayesian Model Averaging
comb_bps <- BPS_PseudoBMA(fit_list = fit_list)
}

}
