% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SOMnn.R
\docType{class}
\name{SOMnn-class}
\alias{SOMnn-class}
\alias{SOMnn}
\title{An S4 class to hold a model for the topological classifier som.nn}
\description{
Objects of type \code{SOMnn} can be created by training a self-organising map
with \link{som.nn.train}.
}
\section{Slots}{

\describe{
\item{\code{name}}{optional name of the model.}

\item{\code{date}}{time and date of creation.}

\item{\code{codes}}{\code{data.frame} with codebook vectors of the som.}

\item{\code{qerror}}{sum of the mapping errors of the training data.}

\item{\code{class.idx}}{column index of column with class labels in input data.}

\item{\code{classes}}{\code{character} vector with names of categories.}

\item{\code{class.counts}}{\code{data.frame} with class hits for each neuron.}

\item{\code{class.freqs}}{\code{data.frame} with class frequencies for each neuron
(freqs sum up to 1).}

\item{\code{norm}}{\code{logical}; if TRUE, data is normalised before training and mapping.
Parameters for normalisation of training data is stored in the model and
applied before mapping of test data.}

\item{\code{norm.center}}{vector of centers for each column of training
data.}

\item{\code{norm.scale}}{vector of scale factors for each column of training
data.}

\item{\code{confusion}}{\code{data.frame} with confusion matrix for training data.}

\item{\code{measures}}{\code{data.frame} with classes as rows and the
columns sensitivity, specificity and accuracy for each class.}

\item{\code{accuracy}}{The overall accuracy calculated based on the confusion matrix cmat:
\eqn{acc = sum(diag(cmat)) / sum(cmat)}.}

\item{\code{xdim}}{number of neurons in x-direction of the som.}

\item{\code{ydim}}{number of neurons in y-direction of the som.}

\item{\code{len.total}}{total number of training steps, performed to create the model.}

\item{\code{toroidal}}{\code{logical}; if TRUE, the map is toroidal (i.e. borderless).}

\item{\code{dist.fun}}{\code{function}; kernel for the kNN classifier.}

\item{\code{max.dist}}{maximum distance for the kNN classifier.}

\item{\code{strict}}{Minimum vote for the winner (if the winner's vote is smaller than strict,
"unknown" is reported as class label (\code{default = 0.8}).}
}}

