% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reflect.data.R
\name{reflect.data}
\alias{reflect.data}
\title{Data reflection for kernel smoothing}
\usage{
reflect.data(X, y)
}
\arguments{
\item{X}{Matrix of inputs}

\item{y}{Vector of outputs}
}
\value{
Returns a list with the following elements
\item{X.reflected}{Reflected values of X}
\item{y.reflected}{Reflected values of y}
}
\description{
This function reflects data below minimum and above maximum for use in reducing endpoint bias in kernel smoothing.
}
\examples{
data(univariate)

#Extract data
X <- as.matrix(univariate$x)
y <- univariate$y

#Reflect data
reflected.data <- reflect.data(X, y)

X.reflected <- reflected.data$X
y.reflected <- reflected.data$y

#Plot
library(ggplot2)

plot.df <- data.frame(X = X.reflected,
                      y = y.reflected,
                      data = rep(c("reflected", "actual", "reflected"), each = nrow(X)))

ggplot(plot.df, aes(X, y)) +
  geom_point(aes(color = data))

}
