% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ANOVA.summary.table.R
\name{ANOVA.summary.table}
\alias{ANOVA.summary.table}
\title{Generate a Summary Table for ANOVA Results}
\usage{
ANOVA.summary.table(model, caption, latex = TRUE)
}
\arguments{
\item{model}{A model object for which ANOVA results are computed (e.g., output from `lm()` or `aov()`).}

\item{caption}{A character string to be used as the caption for the table.}

\item{latex}{Logical; if `TRUE`, returns a LaTeX-formatted table using `kableExtra`. If `FALSE`, prints a plain-text version to the console.}
}
\value{
If `latex = TRUE`, a LaTeX-formatted table object. If `latex = FALSE`, prints the summary table and returns it (invisibly).
}
\description{
This function creates a summary table for ANOVA results, including degrees of freedom,
sum of squares, mean squares, F-values, and p-values. The table can be output as either
LaTeX (for PDF reports) or plain text (for console viewing).
}
\examples{
# Fit a linear model
model <- lm(mpg ~ wt + hp, data = mtcars)

# Generate a plain-text ANOVA summary table
ANOVA.summary.table(model, caption = "ANOVA Summary", latex = FALSE)

}
