% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothedLasso.r
\name{elasticNet}
\alias{elasticNet}
\title{Auxiliary function which returns the objective, penalty, and dependence structure among regression coefficients of the elastic net.}
\usage{
elasticNet(X, y, alpha)
}
\arguments{
\item{X}{The design matrix.}

\item{y}{The response vector.}

\item{alpha}{The regularization parameter of the elastic net.}
}
\value{
A list with six functions, precisely the objective \eqn{u}, penalty \eqn{v}, and dependence structure \eqn{w}, as well as their derivatives \eqn{du}, \eqn{dv}, and \eqn{dw}.
}
\description{
Auxiliary function which returns the objective, penalty, and dependence structure among regression coefficients of the elastic net.
}
\examples{
library(smoothedLasso)
n <- 100
p <- 500
betavector <- runif(p)
X <- matrix(runif(n*p),nrow=n,ncol=p)
y <- X \%*\% betavector
alpha <- 0.5
temp <- elasticNet(X,y,alpha)

}
\references{
Zou, H. and Hastie, T. (2005). Regularization and variable selection via the elastic net. J Roy Stat Soc B Met, 67(2):301-320.

Friedman, J., Hastie, T., Tibshirani, R., Narasimhan, B., Tay, K., Simon, N., and Qian, J. (2020). glmnet: Lasso and Elastic-Net Regularized Generalized Linear Models. R-package version 4.0.

Hahn, G., Lutz, S., Laha, N., and Lange, C. (2020). A framework to efficiently smooth L1 penalties for linear regression. bioRxiv:2020.09.17.301788.
}
