% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparma.R
\name{sparma}
\alias{sparma}
\title{Sparse ARMA Model in State Space Form}
\usage{
sparma(data, orders = list(ar = c(1), ma = c(1)), constant = FALSE,
  loss = c("likelihood", "MSE", "MAE", "HAM", "LASSO", "RIDGE", "MSEh",
  "TMSE", "GTMSE", "MSCE", "GPL"), h = 0, holdout = FALSE, arma = NULL,
  initial = c("backcasting", "optimal", "two-stage", "complete"),
  bounds = c("none", "usual", "admissible"), silent = TRUE, ...)
}
\arguments{
\item{data}{Vector or ts object with the data}

\item{orders}{List with vectors for ar and ma, specifying, which AR and MA orders to fit
e.g. orders=list(ar=c(1,4), ma=0) will fit ARMA
\eqn{y_{t} = phi_1 y_{t-1} + phi_4 y_{t-4} + e_t}}

\item{constant}{Logical, whether to include a constant term (default: FALSE)}

\item{loss}{Loss function type.}

\item{h}{Forecast horizon (default: 0)}

\item{holdout}{Logical, whether to use holdout sample (default: FALSE)}

\item{arma}{List with ar and ma parameters if they do not need to be estimated}

\item{initial}{Initialisation method for states}

\item{bounds}{Parameter bounds}

\item{silent}{Logical, whether to suppress output (default: TRUE)}

\item{...}{Other parameters passed to god knows what.}
}
\value{
Object of class c("adam", "smooth") containing:
\itemize{
  \item model - Model name
  \item timeElapsed - Computation time
  \item data - Input data
  \item holdout - Holdout sample (if applicable)
  \item fitted - Fitted values
  \item residuals - Residuals
  \item forecast - Point forecasts if h>0
  \item states - State matrix
  \item persistence - Persistence vector (g)
  \item transition - Transition matrix (F)
  \item measurement - Measurement matrix (W)
  \item B - Vector of estimated parameters
  \item orders - Orders specified by the user
  \item constant - Constant value (if included)
  \item arma - vector of ARMA parameters
  \item initial - Initial state values
  \item initialType - Type of initialisation
  \item nParam - Number of parameters
  \item logLik - Log-likelihood value
  \item loss - Loss function used in the estimation
  \item lossValue - Value of the loss function
  \item accuracy - Accuracy measures
}
}
\description{
Implements a Sparse ARMA model in the State Space form.
Unlike standard ARIMA which expands polynomials,
this function directly maps AR and MA orders to specific lags.
}
\details{
The model implements: \deqn{y_t = phi * y_{t-p} + theta * epsilon_{t-q} + epsilon_t}
with a possibility of defining several lags for AR/MA.
}
\examples{
\dontrun{
# Fit SpARMA(1,1) model
model <- sparma(BJSales, orders=c(2,1), h=12, holdout=TRUE)

# Provide fixed parameters
model <- sparma(rnorm(100), orders=c(1,1), arma=c(0.7,0.5))
}

}
