% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tune_imp.R
\name{compute_metrics}
\alias{compute_metrics}
\title{Compute Prediction Accuracy Metrics}
\usage{
compute_metrics(results, metrics = c("mae", "rmse", "rsq"))
}
\arguments{
\item{results}{A tibble from \code{\link[=tune_imp]{tune_imp()}} containing a \code{result} column
with tibbles that have \code{truth} and \code{estimate} columns.}

\item{metrics}{A character vector of metric names to compute. Defaults
to \code{c("mae", "rmse", "rsq")}. Also available: \code{"mape"}, \code{"bias"}, \code{"calc_rsq_trad"}.}
}
\value{
A tibble with the original parameters and unnested metrics
(\code{.metric}, \code{.estimator}, \code{.estimate}).
}
\description{
Computes prediction accuracy metrics for results from \code{\link[=tune_imp]{tune_imp()}}.
}
\details{
For alternative or faster metrics, see the \code{{yardstick}} package.
}
\examples{
data(khanmiss1)
set.seed(1234)
results <- tune_imp(
  obj = t(khanmiss1),
  parameters = data.frame(k = 10),
  .f = "knn_imp",
  rep = 1,
  num_na = 20
)

compute_metrics(results)

}
