% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anlvm.fit.R
\name{anlvm.fit}
\alias{anlvm.fit}
\title{Auxiliary Nonlinear Variance Model}
\usage{
anlvm.fit(
  mainlm,
  g,
  M = NULL,
  cluster = FALSE,
  varselect = c("none", "hettest", "cv.linear", "cv.cluster", "qgcv.linear",
    "qgcv.cluster"),
  nclust = c("elbow.swd", "elbow.mwd", "elbow.both"),
  clustering = NULL,
  param.init = function(q) stats::runif(n = q, min = -5, max = 5),
  maxgridrows = 20L,
  nconvstop = 3L,
  zerosallowed = FALSE,
  maxitql = 100L,
  tolql = 1e-08,
  nestedql = FALSE,
  reduce2homosked = TRUE,
  cvoption = c("testsetols", "partitionres"),
  nfolds = 5L,
  ...
)
}
\arguments{
\item{mainlm}{Either an object of \code{\link[base]{class}} \code{"lm"}
(e.g., generated by \code{\link[stats]{lm}}), or
a list of two objects: a response vector and a design matrix. The objects
are assumed to be in that order, unless they are given the names
\code{"X"}  and \code{"y"} to distinguish them. The design matrix passed
in a list must begin with a column of ones if an intercept is to be
included in the linear model. The design matrix passed in a list should
not contain factors, as all columns are treated 'as is'. For tests that
use ordinary least squares residuals, one can also pass a vector of
residuals in the list, which should either be the third object or be
named \code{"e"}.}

\item{g}{A numeric-valued function of one variable, or a character denoting
the name of such a function. \code{"sq"} is allowed as a way of denoting
\code{function(x) x ^ 2}.}

\item{M}{An \eqn{n\times n} annihilator matrix. If \code{NULL}
(the default), this will be calculated from the \code{mainlm} object}

\item{cluster}{A logical; should the design matrix X be replaced with an
\eqn{n\times n_c} matrix of ones and zeroes, with a single one in each
row, indicating assignments of the \eqn{n} observations to \eqn{n_c}
clusters using an agglomerative hierarchical clustering algorithm. In
this case, the dimensionality of \eqn{\gamma} is \eqn{n_c} and not
\eqn{p}. Defaults to \code{FALSE}}

\item{varselect}{Either a character indicating how variable selection should
   be conducted, or an integer vector giving indices of columns of the
   predictor matrix (\code{\link[stats]{model.matrix}} of \code{mainlm})
   to select. The vector must include \code{1L} for the intercept to be
   selected. If a character, it must be one of the following:
\itemize{
 \item \code{"none"}: No variable selection is conducted;
 \item \code{"hettest"}: Variable selection is conducted by applying a
   heteroskedasticity test with each feature in turn serving as the
   `deflator' variable
 \item \code{"cv.linear"}: Variable selection is conducted by best subset
   selection on the auxiliary linear variance model (linear specification),
   using squared-error loss computed under \eqn{K}-fold cross-validation
 \item \code{"cv.cluster"}: Variable selection is conducted by best subset
   selection on the auxiliary linear variance model (clustering
   specification), using squared-error loss computed under \eqn{K}-fold
   cross-validation
 \item \code{"qgcv.linear"}: Variable selection is conducted by best subset
   selection on the auxiliary linear variance model (linear specification),
   using squared-error loss computed under quasi-generalised
   cross-validation
 \item \code{"qgcv.cluster"}: Variable selection is conducted by best subset
   selection on the auxiliary linear variance model (clustering
   specification), using squared-error loss computed under
   quasi-generalised cross-validation
}}

\item{nclust}{A character indicating which elbow method to use to select
the number of clusters (ignored if \code{cluster} is \code{FALSE}).
Alternatively, an integer specifying the number of clusters}

\item{clustering}{A list object of class \code{"doclust"}. If set to
\code{NULL} (the default), such an object is generated (ignored if
\code{cluster} is \code{FALSE})}

\item{param.init}{Specifies the initial values of the parameter vector to
use in the Gauss-Newton fitting algorithm. This can either be a function
for generating the initial values from a probability distribution, a
list containing named objects corresponding to the arguments of
\code{\link[base]{seq}} (specifying a sequence of scalar values that
will be passed to \code{\link[base]{expand.grid}}), or a numeric vector
specifying a single initial parameter vector}

\item{maxgridrows}{An integer indicating the maximum number of initial
values of the parameter vector to try, in case of \code{param.init}
being a function or a list used to generate a grid. Defaults to
\code{20L}.}

\item{nconvstop}{An integer indicating how many times the quasi-likelihood
estimation algorithm should converge before the grid search across
different initial parameter values is truncated. Defaults to \code{3L}.
If \code{nconvstop >= maxgridrows}, no early stopping rule will be used.}

\item{zerosallowed}{A logical indicating whether 0 values are acceptable
in the initial values of the parameter vector. Defaults to \code{FALSE}.}

\item{maxitql}{An integer specifying the maximum number of iterations to
run in the Gauss-Newton algorithm for quasi-likelihood estimation.
Defaults to \code{100L}.}

\item{tolql}{A double specifying the convergence criterion for the
Gauss-Newton algorithm; defaults to \code{1e-8}. The criterion is applied
to the \code{L_2} norm of the difference between parameter vectors in
successive iterations.}

\item{nestedql}{A logical indicating whether to use the nested updating step
suggested in \insertCite{Seber03;textual}{skedastic}. Defaults to
\code{FALSE} due to the large computation time required.}

\item{reduce2homosked}{A logical indicating whether the homoskedastic
error variance estimator \eqn{e'e/(n-p)} should be used if the
variable selection procedure does not select any variables. Defaults to
\code{TRUE}.}

\item{cvoption}{A character, either \code{"testsetols"} or
\code{"partitionres"}, indicating how to obtain the observed response
values for each test fold when performing \eqn{K}-fold cross-validation
on an ALVM. The default technique, \code{"testsetols"}, entails fitting
a linear regression model to the test fold of observations from the
original response vector \eqn{y} and predictor matrix \eqn{X}. The
squared residuals from this regression are the observed
responses that are predicted from the trained model to compute the
cross-validated squared error loss function. Under the other technique,
\code{"partitionres"}, the squared residuals from the full
linear regression model are partitioned into training and test folds and
the squared residuals in the test fold are the observed responses that
are predicted for computation of the cross-validated loss.}

\item{nfolds}{An integer specifying the number of folds \eqn{K} to use for
cross-validation, if the \eqn{\lambda} and/or \eqn{n_c} hyperparameters
are to be tuned using cross-validation. Defaults to \code{5L}. One must
ensure that each test fold contains at least \eqn{p+1} observations if
the \code{"testsetols"} technique is used with cross-validation, so that
there are enough degrees of freedom to fit a linear model to the test
fold.}

\item{...}{Other arguments that can be passed to (non-exported) helper
   functions, namely:
\itemize{
 \item \code{greedy}, a logical passed to the functions implementing best subset
   selection, indicating whether or not to use a greedy search rather than
   exhaustive search for the best subset. Defaults to \code{FALSE}, but
   coerced to \code{TRUE} unconditionally if \eqn{p>9}.
 \item \code{distmetric}, a character specifying the distance metric to use in
   computing distance for the clustering algorithm. Corresponds to the
   \code{method} argument of \code{\link[stats]{dist}} and defaults to
   \code{"euclidean"}
 \item \code{linkage}, a character specifying the linkage rule to use in
   agglomerative hierarchical clustering. Corresponds to the \code{method}
   argument of \code{\link[stats]{hclust}} and defaults to
   \code{"complete"}
 \item \code{alpha}, a double specifying the significance level threshold to use
   when applying heteroskedasticity test for the purpose of feature
   selection in an ALVM; defaults to \code{0.1}
 \item \code{testname}, a character corresponding to the name of a function that
   performs a heteroskedasticity test. The function must either be one that
   takes a \code{deflator} argument or \code{\link{breusch_pagan}}. Defaults
   to \code{evans_king}
}}
}
\value{
An object of class \code{"anlvm.fit"}, containing the following:
\itemize{
 \item \code{coef.est}, a vector of parameter estimates, \eqn{\hat{\gamma}}
 \item \code{var.est}, a vector of estimates \eqn{\hat{\omega}} of the error
   variances for all observations
 \item \code{method}, either \code{"cluster"} or \code{"functionalform"},
   depending on whether \code{cluster} was set to \code{TRUE}
 \item \code{ols}, the \code{lm} object corresponding to the original linear
   regression model
 \item \code{fitinfo}, a list containing three named objects, \code{g} (the
   heteroskedastic function), \code{Msq} (the elementwise-square of the
   annihilator matrix \eqn{M}), \code{Z} (the design matrix used in the
   ANLVM, after feature selection if applicable), and \code{clustering}
   (a list object with results of the clustering procedure, if applicable).
 \item \code{selectinfo}, a list containing two named objects,
   \code{varselect} (the value of the eponymous argument), and
   \code{selectedcols} (a numeric vector with column indices of \eqn{X}
   that were selected, with \code{1} denoting the intercept column)
\item \code{qlinfo}, a list containing nine named objects: \code{converged}
   (a logical, indicating whether the Gauss-Newton algorithm converged
   for at least one initial value of the parameter vector),
   \code{iterations} (the number of Gauss-Newton iterations used to
   obtain the parameter estimates returned), \code{Smin} (the minimum
   achieved value of the objective function used in the Gauss-Newton
   routine), and six arguments passed to the function (\code{nested},
   \code{param.init}, \code{maxgridrows}, \code{nconvstop},
   \code{maxitql}, and \code{tolql})
}
}
\description{
Fits an Auxiliary Nonlinear Variance Model (ANLVM) to estimate the error
   variances of a heteroskedastic linear regression model.
}
\details{
The ANLVM model equation is
   \deqn{e_i^2=\displaystyle\sum_{k=1}^{n} g(X_{k\cdot}'\gamma) m_{ik}^2+u_i},
   where \eqn{e_i} is the \eqn{i}th Ordinary Least Squares residual,
   \eqn{X_{k\cdot}} is a vector corresponding to the \eqn{k}th row of the
   \eqn{n\times p} design matrix \eqn{X}, \eqn{m_{ik}^2} is the
   \eqn{(i,k)}th element of the annihilator matrix \eqn{M=I-X(X'X)^{-1}X'},
   \eqn{u_i} is a random error term, \eqn{\gamma} is a \eqn{p}-vector of
   unknown parameters, and \eqn{g(\cdot)} is a continuous, differentiable
   function that need not be linear in \eqn{\gamma}, but must be expressible
   as a function of the linear predictor \eqn{X_{k\cdot}'\gamma}.
   This method has been developed as part of the author's doctoral research
   project.

The parameter vector \eqn{\gamma} is estimated using the maximum
   quasi-likelihood method as described in section 2.3 of
   \insertCite{Seber03;textual}{skedastic}. The optimisation problem is
   solved numerically using a Gauss-Newton algorithm.

For further discussion of feature selection and the methods for choosing the
   number of clusters to use with the clustering version of the model, see
   \code{\link{alvm.fit}}.
}
\examples{
mtcars_lm <- lm(mpg ~ wt + qsec + am, data = mtcars)
myanlvm <- anlvm.fit(mtcars_lm, g = function(x) x ^ 2,
 varselect = "qgcv.linear")

}
\references{
{\insertAllCited{}}
}
\seealso{
\code{\link{alvm.fit}}, \code{\link{avm.ci}}
}
