% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secrets_manager.R
\name{aws_secrets_delete}
\alias{aws_secrets_delete}
\title{Delete a secret}
\usage{
aws_secrets_delete(id, ...)
}
\arguments{
\item{id}{(character) The name or ARN of the secret. required}

\item{...}{further named parameters passed on to \code{delete_secret}
\url{https://www.paws-r-sdk.com/docs/secretsmanager_delete_secret/}}
}
\value{
(list) with fields:
\itemize{
\item ARN
\item Name
\item DeletionDate
}
}
\description{
Delete a secret
}
\examples{
\dontshow{if (aws_has_creds() && interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
try({
# Create a secret
secret <- random_string("secret-", size = 16)
aws_secrets_create(
  name = secret,
  secret = '{"username":"jill","password":"cow"}',
  description = "The fox jumped over the cow"
)

# Delete a secret
aws_secrets_delete(id = secret, ForceDeleteWithoutRecovery = TRUE)
})
\dontshow{\}) # examplesIf}
}
