% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/policies.R
\name{aws_policy_update}
\alias{aws_policy_update}
\title{Update a policy}
\usage{
aws_policy_update(arn, document, default = FALSE)
}
\arguments{
\item{arn}{(character) policy arn. required}

\item{document}{(character) the policy document you want to use
as the content for the new policy. required}

\item{default}{(character) set this version as the policy's default version?
optional. When this parameter is \code{TRUE}, the new policy version becomes the
operative version. That is, it becomes the version that is in effect for
the IAM users, groups, and roles that the policy is attached to.
default: \code{FALSE}}
}
\value{
a tibble with policy version details:
\itemize{
\item VersionId
\item IsDefaultVersion
\item CreateDate
}
}
\description{
Update a policy
}
\details{
see docs
\url{https://www.paws-r-sdk.com/docs/iam_create_policy_version/}
}
\examples{
\dontshow{if (aws_has_creds()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
if (aws_policy_exists("polisee")) {
  aws_policy_delete("polisee")
}

# Create policy document
st8ment1 <- aws_policy_statement("iam:GetUser", "*")
st8ment2 <- aws_policy_statement("s3:ListAllMyBuckets", "*")
doc <- aws_policy_document_create(st8ment1, st8ment2)

# Create policy
invisible(aws_policy_create("polisee", document = doc))

# Update the same policy
new_doc <- aws_policy_document_create(st8ment1)
arn <- as_policy_arn("polisee", local = TRUE)
aws_policy_update(arn, document = new_doc, default = TRUE)
aws_policy_list_versions("polisee")

# cleanup - delete the policy
aws_policy_delete_version("polisee", "v1")
aws_policy_delete("polisee")
\dontshow{\}) # examplesIf}
}
\seealso{
Other policies: 
\code{\link{as_policy_arn}()},
\code{\link{aws_policies}()},
\code{\link{aws_policy}()},
\code{\link{aws_policy_attach}()},
\code{\link{aws_policy_create}()},
\code{\link{aws_policy_delete}()},
\code{\link{aws_policy_delete_version}()},
\code{\link{aws_policy_detach}()},
\code{\link{aws_policy_exists}()},
\code{\link{aws_policy_list_entities}()},
\code{\link{aws_policy_list_versions}()}
}
\concept{policies}
