% Generated by roxygen2: do not edit by hand
% Please edit documentation in src/gen_process.cpp, src/gen_process.h
\name{gen_wn}
\alias{gen_wn}
\title{Generate a Gaussian White Noise Process (WN(\eqn{\sigma ^2}{sigma^2}))}
\usage{
gen_wn(N, sigma2 = 1)
}
\arguments{
\item{N}{An \code{integer} for signal length.}

\item{sigma2}{A \code{double} that contains process variance.}
}
\value{
wn A \code{vec} containing the white noise.
}
\description{
Simulates a Gaussian White Noise Process with variance parameter \eqn{\sigma ^2}{sigma^2}.
}
\section{Process Definition}{
 
Gaussian White Noise (WN) with parameter \eqn{\sigma^2 \in {\rm I\!R}^{+}}{sigma^2 in R^{+}}.
This process is defined as \eqn{X_t\sim N(0,\sigma^2)}{X[t] ~ N(0,sigma^2)} and
is sometimes referred to as Angle (Velocity) Random Walk.
}

\section{Generation Algorithm}{

To generate the Gaussian White Noise (WN) process, we first obtain the 
standard deviation from the variance by taking a square root. Then, we 
sample \eqn{N} times from a \eqn{N(0,\sigma ^2)}{N(0,sigma^2)} distribution.
}

\keyword{internal}
