% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simer.Parameter.r
\name{param.global}
\alias{param.global}
\title{Global parameters generator}
\usage{
param.global(SP = NULL, ...)
}
\arguments{
\item{SP}{a list of all simulation parameters.}

\item{...}{one or more parameter(s) for global options.}
}
\value{
the function returns a list containing
\describe{
\item{$replication}{the replication times of simulation.}
\item{$seed.sim}{simulation random seed.}
\item{$out}{the prefix of output files.}
\item{$outpath}{the path of output files, Simer writes files only if outpath is not "NULL".}
\item{$out.format}{"numeric" or "plink", the data format of output files.}
\item{$pop.gen}{the generations of simulated population.}
\item{$out.geno.gen}{the output generations of genotype data.}
\item{$out.pheno.gen}{the output generations of phenotype data.}
\item{$useAllGeno}{whether to use all genotype data to simulate phenotype.}
\item{$missing.geno}{the ratio of missing values in genotype data.}
\item{$missing.phe}{the ratio of missing values in phenotype data.}
\item{$ncpus}{the number of threads used, if NULL, (logical core number - 1) is automatically used.}
\item{$verbose}{whether to print detail.}
}
}
\description{
Generate parameters for global options.
}
\details{
Build date: Apr 16, 2022
Last update: Jul 4, 2022
}
\examples{
SP <- param.global(out = "simer")
str(SP)
}
\author{
Dong Yin
}
