% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hazardFunctions.R
\name{avgHRIntegExpOS}
\alias{avgHRIntegExpOS}
\title{Helper Function for \code{avgHRExpOS()}}
\usage{
avgHRIntegExpOS(x, h01, h02, h12, h0, h1, alpha)
}
\arguments{
\item{x}{(\code{numeric})\cr variable of integration.}

\item{h01}{(positive \code{number})\cr transition hazard for 0 to 1 transition.}

\item{h02}{(positive \code{number})\cr transition hazard for 0 to 2 transition.}

\item{h12}{(positive \code{number})\cr transition hazard for 1 to 2 transition.}

\item{h0}{(\code{list})\cr transition parameters for the first treatment group.}

\item{h1}{(\code{list})\cr transition parameters for the second treatment group.}

\item{alpha}{(\code{number})\cr weight parameter, see \code{\link[=avgHRExpOS]{avgHRExpOS()}}.}
}
\value{
This returns the value of the integrand used to calculate
the average hazard ratio for constant transition hazards, see \code{\link[=avgHRExpOS]{avgHRExpOS()}}.
}
\description{
It is an integrand of the form OS hazard function with intensities h01, h02, h12
at time point t multiplied with a weighted product of the two OS Survival functions
at t (one for intensities h0 and one for h1).
}
\examples{
h0 <- list(h01 = 0.18, h02 = 0.06, h12 = 0.17)
h1 <- list(h01 = 0.23, h02 = 0.07, h12 = 0.19)
avgHRIntegExpOS(x = 5, h01 = 0.2, h02 = 0.5, h12 = 0.7, h0 = h0, h1 = h1, alpha = 0.5)
}
