% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select.item.R
\name{select.item}
\alias{select.item}
\title{Select next item}
\usage{
select.item(
  bank,
  model = "3PL",
  theta,
  administered = NULL,
  sel.method = "MFI",
  cat.type = "variable",
  threshold = 0.3,
  SE,
  acceleration = 1,
  met.weight = "mcclarty",
  max.items = 45,
  content.names = NULL,
  content.props = NULL,
  content.items = NULL,
  met.content = "MCCAT"
)
}
\arguments{
\item{bank}{matrix with item parameters (a, b, c)}

\item{model}{may be \verb{3PL} or \code{graded}}

\item{theta}{current theta}

\item{administered}{vector with administered items, \code{NULL} if it is the first
item}

\item{sel.method}{item selection method: may be \code{MFI}, \code{progressive}
or \code{random}}

\item{cat.type}{CAT with \code{variable} or \code{fixed} length.
Necessary only for progressive method.}

\item{threshold}{threshold for \code{cat.type}.
Necessary only for progressive method.}

\item{SE}{current standard error.
Necessary only for progressive method, with \code{cat.type = "variable"}}

\item{acceleration}{acceleration parameter.
Necessary only for progressive method.}

\item{met.weight}{the procedure to calculate the \code{progressive}'s weight in variable-length
CAT. It can be \code{"magis"} or \code{"mcclarty"} (default). See details.}

\item{max.items}{maximum number of items to be administered.
Necessary only for progressive method, with \code{cat.type = "variable"}}

\item{content.names}{vector with the contents of the test}

\item{content.props}{desirable proportion of each content in test, in
the same order of \code{content.names}}

\item{content.items}{vector indicating the content of each item}

\item{met.content}{content balancing method: \code{MCCAT} (default), \code{CCAT}
or \code{MMM}. See \code{content.balancing} for more information.}
}
\value{
A list with two elements
\itemize{
\item \code{item} the number o the selected item in item bank
\item \code{name} name of the selected item (row name)
}
}
\description{
Select next item to be administered
}
\details{
In the progressive (Revuelta & Ponsoda, 1998), the administered item is the one that has the highest weight. The weight of the
item \code{i} is calculated as following:

\deqn{W_i = (1-s)R_i+sI_i}

where \code{R} is a random number between zero and the maximum information of an
item in the bank
for the current theta, \code{I} is the item information and \code{s} is the importance
of the component. As
the application progresses, the random component loses importance. There are some
ways to calculate \code{s}.
For fixed-length CAT, Barrada et al. (2008) uses

\deqn{s = 0}

if it is the first item of the test. For the other administering items,

\deqn{s = \frac{\sum_{f=1}^{q}{(f-1)^k}}{\sum_{f=1}^{Q}{(f-1)^k}}}

where \code{q} is the number of the item position in the test, \code{Q} is the
test length and \code{k} is the acceleration parameter. \code{simCAT} package uses these two
equations for fixed-length CAT. For variable-length, \code{simCAT} package can
use \code{"magis"} (Magis & Barrada, 2017):

\deqn{s = max [ \frac{I(\theta)}{I_{stop}},\frac{q}{M-1}]^k}

where \eqn{I(\theta)} is the item information for the current theta,
\eqn{I_{stop}} is the information corresponding to the stopping error
value, and \code{M} is the maximum length of the test. \code{simCAT} package uses as
default \code{"mcclarty"} (adapted from McClarty et al., 2006):

\deqn{s = (\frac{SE_{stop}}{SE})^k}

where \code{SE} is the standard error for the current theta, \eqn{SE_{stop}} is
the stopping error value.
}
\references{
Barrada, J. R., Olea, J., Ponsoda, V., & Abad, F. J. (2008). \emph{Incorporating randomness in the Fisher information for improving item-exposure control in CATs}. British Journal of Mathematical and Statistical Psychology, 61(2), 493–513. 10.1348/000711007X230937

Leroux, A. J., & Dodd, B. G. (2016). \emph{A comparison of exposure control procedures in CATs using the GPC model}. The Journal of Experimental Education, 84(4), 666–685. 10.1080/00220973.2015.1099511

Magis, D., & Barrada, J. R. (2017). \emph{Computerized adaptive testing with R: recent updates of the package catR}. Journal of Statistical Software, 76(Code Snippet 1). 10.18637/jss.v076.c01

McClarty, K. L., Sperling, R. A., & Dodd, B. G. (2006). \emph{A variant of the progressive-restricted item exposure control procedure in computerized adaptive testing}. Annual Meeting of the American Educational Research Association, San Francisco

Revuelta, J., & Ponsoda, V. (1998). \emph{A comparison of item exposure control methods in computerized adaptive testing}. Journal of Educational Measurement, 35(4), 311–327. http://www.jstor.org/stable/1435308
}
\author{
Alexandre Jaloto
}
