% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irt_estimate.R
\name{logLik_theta}
\alias{logLik_theta}
\title{Log-likelihood estiamtion of theta}
\usage{
logLik_theta(theta, x, item_par)
}
\arguments{
\item{theta}{\code{numeric} vector with true values of \eqn{\theta}}

\item{x}{\code{integer} vector of 0s and 1s, response pattern of each respondent}

\item{item_par}{\code{data.frame}, dataframe with nrows equal to the number of items and 4 columns, one for each of the item parameters. The columns must be named "a", "b", "c", "e" and must contain the respective IRT parameters, namely discrimination \eqn{a_i}, location \eqn{b_i}, pseudo-guessing \eqn{c_i}, and upper asymptote \eqn{e_i}.}
}
\value{
The log-likelihood
}
\description{
Log-likelihood estiamtion of theta
}
\examples{
set.seed(123)
n <- 50
theta <- rnorm(500)
item_par <- data.frame(
  b = runif(n, -3, 3),
  a = runif(n, 1.2, 1.9),
  c = rep(0, n),
  e = rep(1, n)
)
obs_response <- obsirt(mpirt(item_par, theta))
# LogLikelihood of theta
logLik_theta(theta, obs_response, item_par)
}
