% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storageclass.R
\name{StorageClass}
\alias{StorageClass}
\title{StorageClass R6 class}
\description{
This class provides a set of methods to create and manage Shiny bookmarkable
state files.
}
\examples{

## ------------------------------------------------
## Method `StorageClass$new`
## ------------------------------------------------

## Only run examples in interactive R sessions
if (interactive()) {

# beginning of application
library(shiny)
library(shinystate)

# Create a StorageClass object with default settings
storage <- StorageClass$new()

# Use a pre-specified directory to store state files
# For purposes of this example, use a temporary directory
storage <- StorageClass$new(local_storage_dir = tempdir())

# use a custom pins board to store bookmarkable state data
# For purposes of this example, use a temporary directory
library(pins)
board <- board_temp()
storage <- StorageClass$new(board_sessions = board)
}

## ------------------------------------------------
## Method `StorageClass$get_sessions`
## ------------------------------------------------

## Only run examples in interactive R sessions
if (interactive()) {

library(shiny)
library(shinystate)

# Create a StorageClass object with default settings
storage <- StorageClass$new()

# obtain session data
storage$get_sessions()
}

## ------------------------------------------------
## Method `StorageClass$restore`
## ------------------------------------------------

## Only run examples in interactive R sessions
if (interactive()) {

library(shinystate)

# Create a StorageClass object with default settings
storage <- StorageClass$new()

# obtain session data
session_df <- storage$get_sessions()

# restore state
# typically run inside a shiny observe or observeEvent call
storage$restore(tail(session_df$url, n = 1))
}

## ------------------------------------------------
## Method `StorageClass$snapshot`
## ------------------------------------------------

## Only run examples in interactive R sessions
if (interactive()) {

library(shinystate)

# Create a StorageClass object with default settings
storage <- StorageClass$new()

# save state with timestamp as metadata
# typically run inside a shiny observe or observeEvent call
storage$snapshot(session_metadata = list(time = Sys.time()))
}

## ------------------------------------------------
## Method `StorageClass$delete`
## ------------------------------------------------

## Only run examples in interactive R sessions
if (interactive()) {

library(shinystate)

# Create a StorageClass object with default settings
storage <- StorageClass$new()

# obtain session data
session_df <- storage$get_sessions()

# delete a session
# typically run inside a shiny observe or observeEvent call
storage$delete(session_df$url[1])
}

## ------------------------------------------------
## Method `StorageClass$register_metadata`
## ------------------------------------------------

## Only run examples in interactive R sessions
if (interactive()) {

library(shinystate)

# Create a StorageClass object with default settings
storage <- StorageClass$new()

# application server code
server <- function(input, output, session) {
  storage$register_metadata()
}
}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{local_storage_dir}}{file path to use for storing bookmarkable state
files. If not specified, a temporary directory on the host system
will be used.}

\item{\code{board_sessions}}{Optional pre-created board object created with the
pins package. If missing, a folder-based pin board will be created using
the \code{local_storage_dir} path.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-StorageClass-new}{\code{StorageClass$new()}}
\item \href{#method-StorageClass-get_sessions}{\code{StorageClass$get_sessions()}}
\item \href{#method-StorageClass-restore}{\code{StorageClass$restore()}}
\item \href{#method-StorageClass-snapshot}{\code{StorageClass$snapshot()}}
\item \href{#method-StorageClass-delete}{\code{StorageClass$delete()}}
\item \href{#method-StorageClass-register_metadata}{\code{StorageClass$register_metadata()}}
\item \href{#method-StorageClass-clone}{\code{StorageClass$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StorageClass-new"></a>}}
\if{latex}{\out{\hypertarget{method-StorageClass-new}{}}}
\subsection{Method \code{new()}}{
Initialize a \code{StorageClass} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StorageClass$new(local_storage_dir = NULL, board_sessions = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{local_storage_dir}}{file path to use for storing bookmarkable state
files. If not specified, a temporary directory on the host system
will be used.}

\item{\code{board_sessions}}{Optional pre-created board object created with the
pins package. If missing, a folder-based pin board will be created using
the \code{local_storage_dir} path.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object with class \code{StorageClass} and the methods described
in this documentation
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{## Only run examples in interactive R sessions
if (interactive()) {

# beginning of application
library(shiny)
library(shinystate)

# Create a StorageClass object with default settings
storage <- StorageClass$new()

# Use a pre-specified directory to store state files
# For purposes of this example, use a temporary directory
storage <- StorageClass$new(local_storage_dir = tempdir())

# use a custom pins board to store bookmarkable state data
# For purposes of this example, use a temporary directory
library(pins)
board <- board_temp()
storage <- StorageClass$new(board_sessions = board)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StorageClass-get_sessions"></a>}}
\if{latex}{\out{\hypertarget{method-StorageClass-get_sessions}{}}}
\subsection{Method \code{get_sessions()}}{
Obtain saved bookmarkable state session metadata

Calls \verb{$get_sessions()} on the \code{\link{StorageClass}} object to extract
the bookmarkable state session metadata. You can leverage this data
frame in your Shiny application to let the user manage their existing
bookmarkable state sessions, for example.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StorageClass$get_sessions()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
data frame of bookmarkable session metadata if at least one
bookmarkable state session has been saved. Otherwise, the return
object will be \code{NULL}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{## Only run examples in interactive R sessions
if (interactive()) {

library(shiny)
library(shinystate)

# Create a StorageClass object with default settings
storage <- StorageClass$new()

# obtain session data
storage$get_sessions()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StorageClass-restore"></a>}}
\if{latex}{\out{\hypertarget{method-StorageClass-restore}{}}}
\subsection{Method \code{restore()}}{
Restore a previous bookmarkable state session
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StorageClass$restore(url, session = shiny::getDefaultReactiveDomain())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{url}}{character with the unique URL assigned to the bookmarkable
state session.}

\item{\code{session}}{The Shiny session to associate with the restore operation}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{## Only run examples in interactive R sessions
if (interactive()) {

library(shinystate)

# Create a StorageClass object with default settings
storage <- StorageClass$new()

# obtain session data
session_df <- storage$get_sessions()

# restore state
# typically run inside a shiny observe or observeEvent call
storage$restore(tail(session_df$url, n = 1))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StorageClass-snapshot"></a>}}
\if{latex}{\out{\hypertarget{method-StorageClass-snapshot}{}}}
\subsection{Method \code{snapshot()}}{
Create a snapshot of bookmarkable state
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StorageClass$snapshot(
  session_metadata = NULL,
  session = shiny::getDefaultReactiveDomain()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{session_metadata}}{Optional named list of additional variables to
include with the default bookmarkable state attributes when creating
the snapshot. Each element of the list must be a single-length item}

\item{\code{session}}{The Shiny session to associate with the snapshot operation}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{## Only run examples in interactive R sessions
if (interactive()) {

library(shinystate)

# Create a StorageClass object with default settings
storage <- StorageClass$new()

# save state with timestamp as metadata
# typically run inside a shiny observe or observeEvent call
storage$snapshot(session_metadata = list(time = Sys.time()))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StorageClass-delete"></a>}}
\if{latex}{\out{\hypertarget{method-StorageClass-delete}{}}}
\subsection{Method \code{delete()}}{
Delete a previous snapshot of bookmarkable state
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StorageClass$delete(url)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{url}}{character with the unique URL assigned to the bookmarkable
state session.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{## Only run examples in interactive R sessions
if (interactive()) {

library(shinystate)

# Create a StorageClass object with default settings
storage <- StorageClass$new()

# obtain session data
session_df <- storage$get_sessions()

# delete a session
# typically run inside a shiny observe or observeEvent call
storage$delete(session_df$url[1])
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StorageClass-register_metadata"></a>}}
\if{latex}{\out{\hypertarget{method-StorageClass-register_metadata}{}}}
\subsection{Method \code{register_metadata()}}{
Register bookmarkable state storage data collection

This method must be called in the application server function to
perform the necessary customizations to bookmarkable state methods.
This function is meant to be called near the beginning of the Shiny
application server function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StorageClass$register_metadata()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{## Only run examples in interactive R sessions
if (interactive()) {

library(shinystate)

# Create a StorageClass object with default settings
storage <- StorageClass$new()

# application server code
server <- function(input, output, session) {
  storage$register_metadata()
}
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StorageClass-clone"></a>}}
\if{latex}{\out{\hypertarget{method-StorageClass-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StorageClass$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
