% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display.R
\name{displayCodeModal}
\alias{displayCodeModal}
\title{Display a shinyAce code editor via shiny modal}
\usage{
displayCodeModal(
  code,
  title = NULL,
  clip = "clipboard",
  footer = shiny::modalButton("Dismiss"),
  size = c("m", "s", "l"),
  easyClose = TRUE,
  fade = TRUE,
  session = shiny::getDefaultReactiveDomain(),
  ...
)
}
\arguments{
\item{code}{Either a language object or a character string.}

\item{title}{An optional title for the dialog.}

\item{clip}{An \code{\link[shiny:icon]{shiny::icon()}} \code{name} that a user can press to copy \code{code} to
the clipboard. If you wish to not have an icon, specify \code{clip = NULL}.}

\item{footer}{UI for footer. Use \code{NULL} for no footer.}

\item{size}{One of \code{"s"} for small, \code{"m"} (the default) for medium,
\code{"l"} for large, or \code{"xl"} for extra large. Note that \code{"xl"} only
works with Bootstrap 4 and above (to opt-in to Bootstrap 4+,
pass \code{\link[bslib:bs_theme]{bslib::bs_theme()}} to the \code{theme} argument of a page container
like \code{\link[shiny:fluidPage]{fluidPage()}}).}

\item{easyClose}{If \code{TRUE}, the modal dialog can be dismissed by
clicking outside the dialog box, or be pressing the Escape key. If
\code{FALSE} (the default), the modal dialog can't be dismissed in those
ways; instead it must be dismissed by clicking on a \code{modalButton()}, or
from a call to \code{\link[shiny:removeModal]{removeModal()}} on the server.}

\item{fade}{If \code{FALSE}, the modal dialog will have no fade-in animation
(it will simply appear rather than fade in to view).}

\item{session}{a shiny session object (the default should almost always be used).}

\item{...}{arguments passed along to \code{shinyAce::aceEditor()}}
}
\value{
nothing. Call this function for its side effects.
}
\description{
Show a \code{shinyAce::aceEditor()} in a \code{shiny::modalDialog()}.
}
\examples{

if (interactive()) {
  library(shiny)
  ui <- fluidPage(
    sliderInput("n", label = "Number of samples", min = 10, max = 100, value = 30),
    actionButton("code", icon("code")),
    plotOutput("p")
  )
  server <- function(input, output) {
    output$p <- metaRender(renderPlot, {
      plot(sample(..(input$n)))
    })
    observeEvent(input$code, {
      code <- expandChain(output$p())
      displayCodeModal(code)
    })
  }
  shinyApp(ui, server)
}

}
\seealso{
\link{outputCodeButton}
}
