% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sortableTableOutput.R
\name{sortableTableOutput}
\alias{sortableTableOutput}
\title{Create a table output element with sortable rows}
\usage{
sortableTableOutput(outputId)
}
\arguments{
\item{outputId}{output variable to read the table from}
}
\value{
A table output element that can be included in a panel
}
\description{
Render a standard HTML table with table rows sortable by drag and drop. The
order of table rows is recorded in \verb{input$<outputId>_order}.
}
\examples{
## Only run this example in interactive R sessions
if (interactive()) {
  shinyApp(
    ui = fluidPage(
      verbatimTextOutput("rows"),
      sortableTableOutput("tbl")
    ),
    server = function(input, output) {
      output$rows <- renderPrint({input$tbl_row_index})
      output$tbl <- renderTable(mtcars, rownames = TRUE)
    }
  )
}

}
\seealso{
\link[shiny:renderTable]{shiny::tableOutput}, \link{sortableRadioButtons},
\link{sortableCheckboxGroupInput}, \link{sortableTabsetPanel},
\link{selectableTableOutput}
}
