% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/providers__oidc_discovery.R
\name{oauth_provider_oidc_discover}
\alias{oauth_provider_oidc_discover}
\title{Discover and create an OpenID Connect (OIDC) \link{OAuthProvider}}
\usage{
oauth_provider_oidc_discover(
  issuer,
  name = NULL,
  use_pkce = TRUE,
  use_nonce = TRUE,
  id_token_validation = TRUE,
  token_auth_style = NULL,
  allowed_algs = c("RS256", "RS384", "RS512", "PS256", "PS384", "PS512", "ES256",
    "ES384", "ES512", "EdDSA"),
  allowed_token_types = c("Bearer"),
  jwks_host_issuer_match = TRUE,
  issuer_match = c("url", "host", "none"),
  ...
)
}
\arguments{
\item{issuer}{The OIDC issuer base URL (including scheme), e.g.,
"https://login.example.com"}

\item{name}{Optional friendly provider name. Defaults to the issuer hostname}

\item{use_pkce}{Logical, whether to use PKCE for this provider. Defaults to
TRUE. If the discovery document indicates \code{token_endpoint_auth_methods_supported}
includes "none", PKCE is required unless \code{use_pkce} is explicitly set to FALSE
(not recommended)}

\item{use_nonce}{Logical, whether to use OIDC nonce. Defaults to TRUE}

\item{id_token_validation}{Logical, whether to validate ID tokens automatically
for this provider. Defaults to TRUE}

\item{token_auth_style}{Authentication style for token requests: "header"
(client_secret_basic) or "body" (client_secret_post). If NULL (default),
it is inferred conservatively from discovery. When PKCE is enabled and the
provider advertises support for public clients via \code{none}, a secretless
flow is preferred (modeled as \code{"body"} without credentials). Otherwise,
the helper prefers \code{"header"} (client_secret_basic) when available, then
\code{"body"} (client_secret_post). JWT-based methods are not auto-selected
unless explicitly requested}

\item{allowed_algs}{Character vector of allowed ID token signing algorithms.
Defaults to a broad set of common algorithms, including RSA (RS*), RSA-PSS
(PS*), ECDSA (ES*), and EdDSA. If the discovery document advertises
supported algorithms, the intersection of advertised and caller-provided
algorithms is used to avoid runtime mismatches. If there's no overlap,
discovery fails with a configuration error (no fallback)}

\item{allowed_token_types}{Character vector of allowed token types for
access tokens issued by this provider. Defaults to 'Bearer'}

\item{jwks_host_issuer_match}{When TRUE (default), enforce that the JWKS host
discovered from the provider matches the issuer host (or a subdomain). For
providers that serve JWKS from a different host, set
\code{jwks_host_allow_only} to the exact hostname instead of disabling this.
Disabling (\code{FALSE}) is not recommended unless you also pin JWKS via
\code{jwks_host_allow_only} or \code{jwks_pins}}

\item{issuer_match}{Character scalar controlling how strictly to validate the
discovery document's \code{issuer} against the input \code{issuer}.
\itemize{
\item \code{"url"} (default): require the full issuer URL to match after
trailing-slash normalization (recommended).
\item \code{"host"}: compare only scheme + host (explicit opt-out; not recommended).
\item \code{"none"}: do not validate issuer consistency.
}

Prefer \code{"url"} and tighten hosts via \code{options(shinyOAuth.allowed_hosts)}
when feasible.}

\item{...}{Additional fields passed to \code{\link[=oauth_provider]{oauth_provider()}}}
}
\value{
\link{OAuthProvider} object configured from discovery
}
\description{
Uses the OpenID Connect discovery document at
\verb{/.well-known/openid-configuration} to auto-configure an \link{OAuthProvider}.
When present, \code{introspection_endpoint} is wired into the resulting provider
for RFC 7662 support.
}
\details{
\itemize{
\item ID token algorithms: by default this helper accepts common asymmetric
algorithms RSA (RS*), RSA-PSS (PS*), ECDSA (ES*), and EdDSA. When the
provider advertises its supported ID token signing algorithms via
\code{id_token_signing_alg_values_supported}, the helper uses the intersection
with the caller-provided \code{allowed_algs}. If there is no overlap, discovery
fails with a configuration error. There is no automatic fallback to the
discovery-advertised set.
\item Token endpoint authentication methods: supports \code{client_secret_basic}
(header), \code{client_secret_post} (body), public clients using \code{none}
(with PKCE), as well as JWT-based methods \code{private_key_jwt} and
\code{client_secret_jwt} per RFC 7523.

Important: discovery metadata lists methods supported across the provider,
not per-client provisioning. This helper does not automatically select
JWT-based methods just because they are advertised. By default it prefers
\code{client_secret_basic} (header) when available, otherwise
\code{client_secret_post} (body), and only uses public \code{none} for PKCE clients.
If a provider advertises only JWT methods, you must explicitly set
\code{token_auth_style} and configure the corresponding credentials on your
\link{OAuthClient} (a private key for \code{private_key_jwt}, or a sufficiently
strong \code{client_secret} for \code{client_secret_jwt}).
\item Host policy: by default, discovered endpoints must be absolute URLs whose
host matches the issuer host exactly. Subdomains are NOT implicitly allowed.
If you want to allow subdomains, add a leading-dot or glob in
\code{options(shinyOAuth.allowed_hosts)}, e.g., \code{.example.com} or \verb{*.example.com}.
If a global whitelist is supplied via \code{options(shinyOAuth.allowed_hosts)},
discovery will restrict endpoints to that whitelist. Scheme policy (https/http for
loopback) is delegated to \code{is_ok_host()}, so you may allow non-HTTPS hosts
with \code{options(shinyOAuth.allowed_non_https_hosts)} (see \code{?is_ok_host}).
}
}
\examples{
# Configure generic OAuth 2.0 provider (no OIDC)
generic_provider <- oauth_provider(
  name = "example",
  auth_url = "https://example.com/oauth/authorize",
  token_url = "https://example.com/oauth/token",
  # Optional URL for fetching user info:
  userinfo_url = "https://example.com/oauth/userinfo"
)

# Configure generic OIDC provider manually
# (This defaults to using nonce & ID token validation)
generic_oidc_provider <- oauth_provider_oidc(
  name = "My OIDC",
  base_url = "https://my-issuer.example.com"
)

# Configure a OIDC provider via OIDC discovery
# (requires network access)
\donttest{
# Using Auth0 sample issuer as an example
oidc_discovery_provider <- oauth_provider_oidc_discover(
  issuer = "https://samples.auth0.com"
)
}

# GitHub preconfigured provider 
github_provider <- oauth_provider_github()

# Google preconfigured provider
google_provider <- oauth_provider_google()

# Microsoft preconfigured provider
# See `?oauth_provider_microsoft` for example using a custom tenant ID

# Spotify preconfigured provider 
spotify_provider <- oauth_provider_spotify()

# Slack via OIDC discovery
# (requires network access)
\donttest{
slack_provider <- oauth_provider_slack()
}
  
# Keycloak
# (requires configured Keycloak realm; example below is therefore not run)
\dontrun{
oauth_provider_keycloak(base_url = "http://localhost:8080", realm = "myrealm")
}

# Auth0
# (requires configured Auth0 domain; example below is therefore not run)
\dontrun{
oauth_provider_auth0(domain = "your-tenant.auth0.com")
}

# Okta
# (requires configured Okta domain; example below is therefore not run)
\dontrun{
oauth_provider_okta(domain = "dev-123456.okta.com")
}
}
