% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twSelectInput.R
\name{twSelectInput}
\alias{twSelectInput}
\title{Wrapper around \code{\link[shiny:selectInput]{shiny::selectInput()}} but allowing for more classes}
\usage{
twSelectInput(
  inputId,
  label,
  choices,
  selected = NULL,
  multiple = FALSE,
  selectize = TRUE,
  width = NULL,
  size = NULL,
  container_class = NULL,
  label_class = NULL,
  select_class = NULL
)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Display label for the control, or \code{NULL} for no label.}

\item{choices}{List of values to select from. If elements of the list are
named, then that name --- rather than the value --- is displayed to the
user. It's also possible to group related inputs by providing a named list
whose elements are (either named or unnamed) lists, vectors, or factors. In
this case, the outermost names will be used as the group labels (leveraging
the \verb{<optgroup>} HTML tag) for the elements in the respective sublist. See
the example section for a small demo of this feature.}

\item{selected}{The initially selected value (or multiple values if \code{multiple = TRUE}). If not specified then defaults to the first value for
single-select lists and no values for multiple select lists.}

\item{multiple}{Is selection of multiple items allowed?}

\item{selectize}{Whether to use \pkg{selectize.js} or not.}

\item{width}{The width of the input, e.g. \code{'400px'}, or \code{'100\%'};
see \code{\link[shiny:validateCssUnit]{validateCssUnit()}}.}

\item{size}{Number of items to show in the selection box; a larger number
will result in a taller box. Not compatible with \code{selectize=TRUE}.
Normally, when \code{multiple=FALSE}, a select input will be a drop-down list,
but when \code{size} is set, it will be a box instead.}

\item{container_class}{additional classes to be applied to the container}

\item{label_class}{additional classes to be applied to the label}

\item{select_class}{additional classes to be applied to the select elements}
}
\value{
a list with a \code{shiny.tag} class
}
\description{
Wrapper around \code{\link[shiny:selectInput]{shiny::selectInput()}} but allowing for more classes
}
\examples{
shiny::selectInput("id", "label", c("A" = "a", "B" = "b", "C" = "c"),
  selected = c("a", "b"), width = "200px",
  multiple = TRUE
)
twSelectInput("id", "label", c("A" = "a", "B" = "b", "C" = "c"),
  selected = c("a", "b"), width = "200px",
  multiple = TRUE, selectize = TRUE,
  container_class = "CONTAINER", label_class = "LABEL",
  select_class = "SELECT"
)

# basic full shiny example
library(shiny)

ui <- fluidPage(
  use_tailwind(),
  twSelectInput(
    "variable", "Variable to select:",
    c("Cylinders" = "cyl", "Transmission" = "am", "Gears" = "gear"),
    multiple = TRUE,
    # Apply tailwind classes
    container_class = "shadow-md rounded-md bg-gray-50 m-4 p-2 w-72",
    label_class = "font-serif",
    select_class = "font-mono font-bold text-red-800 rounded-md bg-stone-50"
  ),
  tableOutput("data")
)

server <- function(input, output) {
  output$data <- renderTable(
    {
      mtcars[, c("mpg", input$variable), drop = FALSE]
    },
    rownames = TRUE
  )
}

if (interactive()) shiny::shinyApp(ui, server)
}
\seealso{
\code{\link[shiny:selectInput]{shiny::selectInput()}}
}
