% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsl.R
\name{field}
\alias{field}
\title{Create Semantic UI field tag}
\usage{
field(..., class = "")
}
\arguments{
\item{...}{Other arguments to be added as attributes of the
tag (e.g. style, class or childrens etc.)}

\item{class}{Additional classes to add to html tag.}
}
\description{
This creates a field tag using Semantic UI styles.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()){
  library(shiny)
  library(shiny.semantic)

  ui <- shinyUI(semanticPage(
    form(
      field(
        tags$label("Name"),
        text_input("name", value = "", type = "text", placeholder = "Enter Name...")
      ),
      # error field
      field(
        class = "error",
        tags$label("Name"),
        text_input("name", value = "", type = "text", placeholder = "Enter Name...")
      ),
      # disabled
      field(
        class = "disabled",
        tags$label("Name"),
        text_input("name", value = "", type = "text", placeholder = "Enter Name...")
      )
    )
  ))
  server <- shinyServer(function(input, output) {
  })

  shinyApp(ui, server)
}

}
