% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R, R/documentation.R, R/examples.R
\name{Stack}
\alias{Stack}
\title{Stack}
\usage{
Stack(...)
}
\arguments{
\item{...}{Props to pass to the component.
The allowed props are listed below in the \bold{Details} section.}
}
\value{
Object with \code{shiny.tag} class suitable for use in the UI of a Shiny app.
}
\description{
A \code{Stack} is a container-type component that abstracts the implementation of a flexbox in order to define the layout of its children components.
\subsection{Stack Properties}{

Although the \code{Stack} component has a number of different properties, there are three in particular that define the overall layout that the component has:
\enumerate{
\item Direction: Refers to whether the stacking of children components is horizontal or vertical. By default the \code{Stack} component is vertical, but can be turned horizontal by adding the \code{horizontal} property when using the component.
\item Alignment: Refers to how the children components are aligned inside the container. This is controlled via the \code{verticalAlign} and \code{horizontalAlign} properties. One thing to notice here is that while flexbox containers align always across the cross axis, \code{Stack} aims to remove the mental strain involved in this process by making the \code{verticalAlign} and \code{horizontalAlign} properties always follow the vertical and horizontal axes, respectively, regardless of the direction of the \code{Stack}.
\item Spacing: Refers to the space that exists between children components inside the \code{Stack}. This is controlled via the \code{gap} and \code{verticalGap} properties.
}
}

\subsection{Stack Items}{

The \code{Stack} component provides an abstraction of a flexbox container but there are some flexbox related properties that are applied on specific children of the flexbox instead of being applied on the container. This is where \verb{Stack Items} comes into play.

A \verb{Stack Item} abstracts those properties that are or can be specifically applied on flexbox's children, like \code{grow} and \code{shrink}.

To use a \verb{Stack Item} in an application, the \code{Stack} component should be imported and \code{Stack.Item} should be used inside of a \code{Stack}. This is done so that the existence of the \verb{Stack Item} is inherently linked to the \code{Stack} component.
\subsection{Stack Wrapping}{

Aside from the previously mentioned properties, there is another property called \code{wrap} that determines if items overflow the \code{Stack} container or wrap around it. The wrap property only works in the direction of the \code{Stack}, which means that the children components can still overflow in the perpendicular direction (i.e. in a \verb{Vertical Stack}, items might overflow horizontally and vice versa).
}

\subsection{Stack Nesting}{

\code{Stacks} can be nested inside one another in order to be able to configure the layout of the application as desired.

For more details and examples visit the \href{https://developer.microsoft.com/en-us/fluentui#/controls/web/Stack}{official docs}.
The R package cannot handle each and every case, so for advanced use cases
you need to work using the original docs to achieve the desired result.
}

}
}
\details{
\itemize{
\item \bold{ align } \code{'auto' | 'stretch' | 'baseline' | 'start' | 'center' | 'end'} \cr Defines how to align the StackItem along the x-axis (for vertical Stacks) or the y-axis (for horizontal Stacks).
\item \bold{ className } \code{string} \cr Defines a CSS class name used to style the StackItem.
\item \bold{ disableShrink } \code{boolean} \cr Defines whether the StackItem should be prevented from shrinking. This can be used to prevent a StackItem from shrinking when it is inside of a Stack that has shrinking items.
\item \bold{ grow } \code{boolean | number | 'inherit' | 'initial' | 'unset'} \cr Defines how much to grow the StackItem in proportion to its siblings.
\item \bold{ order } \code{number | string} \cr Defines order of the StackItem.
\item \bold{ shrink } \code{boolean | number | 'inherit' | 'initial' | 'unset'} \cr Defines at what ratio should the StackItem shrink to fit the available space.
\item \bold{ verticalFill } \code{boolean} \cr Defines whether the StackItem should take up 100\% of the height of its parent.
\item \bold{ as } \verb{React.ElementType<React.HTMLAttributes<HTMLElement>>} \cr Defines how to render the Stack.
\item \bold{ disableShrink } \code{boolean} \cr Defines whether Stack children should not shrink to fit the available space.
\item \bold{ gap } \code{number | string} \cr Defines the spacing between Stack children. The property is specified as a value for 'row gap', followed optionally by a value for 'column gap'. If 'column gap' is omitted, it's set to the same value as 'row gap'.
\item \bold{ grow } \code{boolean | number | 'inherit' | 'initial' | 'unset'} \cr Defines how much to grow the Stack in proportion to its siblings.
\item \bold{ horizontal } \code{boolean} \cr Defines whether to render Stack children horizontally.
\item \bold{ horizontalAlign } \code{Alignment} \cr Defines how to align Stack children horizontally (along the x-axis).
\item \bold{ maxHeight } \code{number | string} \cr Defines the maximum height that the Stack can take.
\item \bold{ maxWidth } \code{number | string} \cr Defines the maximum width that the Stack can take.
\item \bold{ padding } \code{number | string} \cr Defines the inner padding of the Stack.
\item \bold{ reversed } \code{boolean} \cr Defines whether to render Stack children in the opposite direction (bottom-to-top if it's a vertical Stack and right-to-left if it's a horizontal Stack).
\item \bold{ verticalAlign } \code{Alignment} \cr Defines how to align Stack children vertically (along the y-axis).
\item \bold{ verticalFill } \code{boolean} \cr Defines whether the Stack should take up 100\% of the height of its parent. This property is required to be set to true when using the \code{grow} flag on children in vertical oriented Stacks. Stacks are rendered as block elements and grow horizontally to the container already.
\item \bold{ wrap } \code{boolean} \cr Defines whether Stack children should wrap onto multiple rows or columns when they are about to overflow the size of the Stack.
}
}
\examples{
library(shiny)
library(shiny.fluent)

ui <- function(id) {
  ns <- NS(id)
  Stack(
    tokens = list(childrenGap = 10),
    reversed = TRUE,
    span("Item One"),
    span("Item Two"),
    span("Item Three")
  )
}

server <- function(id) {
  moduleServer(id, function(input, output, session) {})
}

if (interactive()) {
  shinyApp(ui("app"), function(input, output) server("app"))
}
}
