% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_arrow.R
\name{write_sf_dataset}
\alias{write_sf_dataset}
\title{Write \code{sf} object to an Arrow multi-file dataset}
\usage{
write_sf_dataset(
  obj,
  path,
  format = "parquet",
  partitioning = dplyr::group_vars(obj),
  ...
)
}
\arguments{
\item{obj}{object of class \code{\link[sf]{sf}}}

\item{path}{string path referencing a directory for the output}

\item{format}{output file format ("parquet" or "feather")}

\item{partitioning}{character vector of columns in \code{obj} for grouping or
the \code{dplyr::group_vars}}

\item{...}{additional arguments and options passed to
\code{arrow::write_dataset}}
}
\value{
\code{obj} invisibly
}
\description{
Write \code{sf} object to an Arrow multi-file dataset
}
\details{
Translate an \code{sf} spatial object to \code{data.frame} with WKB
geometry columns and then write to an \code{arrow} dataset with
partitioning. Allows for \code{dplyr} grouped datasets (using
\code{\link[dplyr]{group_by}}) and uses those variables to define
partitions.
}
\examples{
# read spatial object
nc <- sf::st_read(system.file("shape/nc.shp", package="sf"), quiet = TRUE)

# create random grouping
nc$group <- sample(1:3, nrow(nc), replace = TRUE)

# use dplyr to group the dataset. \%>\% also allowed
nc_g <- dplyr::group_by(nc, group)

# write out to parquet datasets
tf <- tempfile()  # create temporary location
on.exit(unlink(tf))
# partitioning determined by dplyr 'group_vars'
write_sf_dataset(nc_g, path = tf)

list.files(tf, recursive = TRUE)

# open parquet files from dataset
ds <- arrow::open_dataset(tf)

# create a query. \%>\% also allowed
q <- dplyr::filter(ds, group == 1)

# read the dataset (piping syntax also works)
nc_d <- read_sf_dataset(dataset = q)

nc_d
plot(sf::st_geometry(nc_d))

}
\seealso{
\code{\link[arrow]{write_dataset}}, \code{\link{st_read_parquet}}
}
