% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-divisions.R
\name{Divisions}
\alias{Divisions}
\title{R6 Class representing divisions endpoints.}
\description{
R6 Class representing Divisions resource.
}
\examples{

## ------------------------------------------------
## Method `Divisions$query`
## ------------------------------------------------

\dontrun{
  # Retrieve a list of all divisions you are a member of
  a$Divisions$query()
}

## ------------------------------------------------
## Method `Divisions$get`
## ------------------------------------------------

\dontrun{
  # Retrieve details of a specified division
  a$Divisions$get(id = "division-id")
}
}
\section{Super class}{
\code{\link[sevenbridges2:Resource]{sevenbridges2::Resource}} -> \code{Divisions}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{URL}}{List of URL endpoints for this resource.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Divisions-new}{\code{Divisions$new()}}
\item \href{#method-Divisions-query}{\code{Divisions$query()}}
\item \href{#method-Divisions-get}{\code{Divisions$get()}}
\item \href{#method-Divisions-clone}{\code{Divisions$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="sevenbridges2" data-topic="Resource" data-id="delete"><a href='../../sevenbridges2/html/Resource.html#method-Resource-delete'><code>sevenbridges2::Resource$delete()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Divisions-new"></a>}}
\if{latex}{\out{\hypertarget{method-Divisions-new}{}}}
\subsection{Method \code{new()}}{
Create new Divisions resource object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Divisions$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Other response arguments.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Divisions-query"></a>}}
\if{latex}{\out{\hypertarget{method-Divisions-query}{}}}
\subsection{Method \code{query()}}{
This call retrieves a list of all divisions you are a
member of. Each division's ID, name and URL on platform will be
returned.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Divisions$query()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{\link{Collection}} of \code{\link{Division}} objects.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
  # Retrieve a list of all divisions you are a member of
  a$Divisions$query()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Divisions-get"></a>}}
\if{latex}{\out{\hypertarget{method-Divisions-get}{}}}
\subsection{Method \code{get()}}{
This call returns the details of a specified division.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Divisions$get(id, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The ID of the division you are querying. The function
also accepts a Division object and extracts the ID.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Division}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
  # Retrieve details of a specified division
  a$Divisions$get(id = "division-id")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Divisions-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Divisions-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Divisions$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
