% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{coit}
\alias{coit}
\title{Coit's method}
\usage{
coit(s, n, alpha, use.backup = FALSE, backup.method, ...)
}
\arguments{
\item{s}{Vector of successes.}

\item{n}{Vector of sample sizes.}

\item{alpha}{The significance level; to calculate a 100(1-\eqn{\alpha})\% lower confidence bound.}

\item{use.backup}{If TRUE, then a backup.method in the will be used for the methods with calculate LCB = 1 in the case of no failures across all components. If FALSE (default), no backup.method is used.}

\item{backup.method}{The backup method which is used for the methods which calculate LCB = 1 in the case of zero failures. Use function name.}

\item{...}{Additional arguments to be ignored.}
}
\value{
The 100(1-\eqn{\alpha})\% lower confidence bound.
}
\description{
Calculate a binomial series lower confidence bound using Coit's (1997) method.
}
\examples{
coit(s=c(35, 97, 59), n=c(35, 100, 60), alpha=.10)
}
