% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPRT-class.R
\docType{class}
\name{SPRT-class}
\alias{SPRT-class}
\title{Class "SPRT". Result of a Sequential Probability Ratio Test}
\description{
This class encapsulates results or specification of a Sequential Probability
Ratio Test.
}
\section{Slots}{

\describe{
\item{\code{call}}{(language) The call to \code{\link{sprt}}.}

\item{\code{data}}{(numeric, logical) Either a vector with cumulative counts or NA.}

\item{\code{hi_int}}{(numeric) Intercept of the lower stop line.}

\item{\code{low_int}}{(numeric) Intercept of the higher stop line.}

\item{\code{slope}}{(numeric) Slope of stop lines.}

\item{\code{recommendation}}{(character, logical) Either a recommendation on whether
to accept H0 or H1, or keep sampling, or NA.}

\item{\code{iterations}}{(numeric) Number of sequential sampling bouts required or
processed.}
}}

\examples{

counts <- c(2, 5, 6, 2, 7)

test11 <- sprt(data = counts,
                mu0 = 2,
                mu1 = 4,
                density_func = "negative binomial",
                overdispersion = 4.6,
                alpha = 0.1,
                beta = 0.1)
show(test11) # returns "accept H1" after 5 sampling bouts processed.

## End (Not run)
}
