% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{mix}
\alias{mix}
\title{Mix several waves}
\usage{
mix(waves, volume = rep(1, length(waves)), pan = rep(0, length(waves)))
}
\arguments{
\item{waves}{List of wave S4 objects (tuneR)}

\item{volume}{Numeric vector, volume between 0 and 1.}

\item{pan}{Numeric vector, pan between -1 (left) and 1 (right) (0 = centered).}
}
\value{
the result of th mix, an S4 Wave object (from package tuneR).
}
\description{
Take several wave objects (package tuneR) and mix them according to volume and pan.
}
\examples{
# A 2-second drum groove (4/4 measure)
# hi-hat on 16th notes
hh <- sequence(hiHat,time=2*(0:15)/16,volume=rep(c(1,rep(0.5,3)),4))
# bass kick on 1 and 3
k <- sequence(kick,time=2*c(0,8)/16)
# snare on 2 and 4
s <- sequence(snare,time=2*c(4,12)/16)
# Mix the 3 tracks
m1 <- mix(list(hh,k,s))
\dontrun{
# All calls to function 'tuneR::play' ar wrapped in \dontrun{} since they rely
# on an external audio player to play the audio sample.
# See ?tuneR::setWavPlayer for setting a default player.
tuneR::play(m1)}
# Try with less hihat, more kick
m2 <- mix(list(hh,k,s),volume=c(0.3,1,0.8))
\dontrun{tuneR::play(m2)}
}
