% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSubjRoute.R
\name{getSubjRoute}
\alias{getSubjRoute}
\title{Extract the set of animals of the specified route of administration - or just
add actual route of administration for each animal.}
\usage{
getSubjRoute(
  dbToken,
  animalList,
  routeFilter = NULL,
  exclusively = FALSE,
  matchAll = FALSE,
  inclUncertain = FALSE,
  noFilterReportUncertain = TRUE
)
}
\arguments{
\item{dbToken}{Mandatory\cr
Token for the open database connection (see \code{\link{initEnvironment}}).}

\item{animalList}{Mandatory, data.table.\cr
A table with the list of animals to process.\cr
The table must include at least columns named 'STUDYID' and 'USUBJID'.}

\item{routeFilter}{Optional, character.\cr
The route of administration value(s) to use as criterion for filtering of the
input data table.\cr
It can be a single string, a vector or a list of multiple strings.}

\item{exclusively}{Mandatory if \code{routeFilter} is non empty, boolean.
\itemize{
\item TRUE: Include animals only for studies with no other routes then
included in \code{routeFilter}.
\item FALSE: Include animals for all studies with route
matching \code{routeFilter}.
}}

\item{matchAll}{Mandatory if \code{routeFilter} is non empty, boolean.
\itemize{
\item TRUE: Include animals only for studies with route(s) matching all
values in \code{routeFilter}.
\item FALSE: Include animals for all studies with route matching at least
one value in \code{routeFilter}.
}}

\item{inclUncertain}{Mandatory if \code{routeFilter} is non empty, boolean,.\cr
Indicates whether animals for which the route cannot be confidently
identified shall be included or not in the output data table.}

\item{noFilterReportUncertain}{Mandatory if \code{routeFilter} is empty, boolean\cr
Only relevant if the \code{routeFilter} is empty.\cr
Indicates if the reason should be included if the route cannot be
confidently decided for an animal.}
}
\value{
The function returns a data.table with columns:
\itemize{
\item STUDYID       (character)
\item Additional columns contained in the \code{animalList} table
\item ROUTE         (character)\cr
The value is always returned in uppercase and trimmed for leading/trailing
blanks.
\item UNCERTAIN_MSG (character)\cr
Included when parameter \code{inclUncertain=TRUE}.\cr
In case the ROUTE cannot be confidently matched during the filtering of data,
the column contains an indication of the reason.\cr
Is NA for rows where ROUTE can be confidently matched.\cr
A non-empty UNCERTAIN_MSG value generated by this function is merged with
non-empty UNCERTAIN_MSG values which may exist in the input set of animals
specified in \code{animalList} - separated by '|'.
\item NOT_VALID_MSG (character)\cr
Included when parameter \code{noFilterReportUncertain=TRUE}.\cr
In case the ROUTE cannot be confidently decided, the column contains an
indication of the reason.\cr
Is NA for rows where the ROUTE can be confidently decided.\cr
A non-empty NOT_VALID_MSG value generated by this function is merged with
non-empty NOT_VALID_MSG values which may exist in the input set of animals
\code{animalList} - separated by '|'.
}
}
\description{
Returns a data table with the set of animals included in the
\code{animalList} matching the route of administration specified in the
\code{routeFilter}.\cr
If the \code{routeFilter} is empty (null, na or empty string) - all rows from
\code{animalList} are returned with an additional populated ROUTE column.
}
\details{
The route of administration per animal are identified by a hierarchical
lookup in these domains
\itemize{
\item EX - If a distinct not empty EXROUTE value is found for animal, this
is included in the output.\cr
\item TS - if a distinct TS parameter 'ROUTE' value exists for the study,
this is included in the output.\cr
}
The comparison of route values is done case insensitive and trimmed for
leading/trailing blanks.

If input parameter \code{inclUncertain=TRUE}, uncertain animals are included
in the output set. These uncertain situations are identified and reported (in
column UNCERTAIN_MSG):
\itemize{
\item TS parameter ROUTE is missing for study and no EX rows contain a
EXROUTE value for the animal
\item The selected EXROUTE or TS parameter ROUTE value is invalid (not CT
value - CDISC SEND code list ROUTE)
\item Multiple EXROUTE values have been found for the animal
\item Multiple TS parameter ROUTE values are registered for study but no EX
rows contain a EXROUTE value for the animal
\item The found EXROUTE value for animal is not included in the TS
parameter ROUTE value(s) registered for study
}
The same checks are performed and reported in column NOT_VALID_MSG if
\code{routeFilter} is empty and \code{noFilterReportUncertain=TRUE}.
}
\examples{
\dontrun{
# Extract animals administered oral or oral gavage plus uncertain animals
getSubjRoute(dbToken, controlAnimals,
             routeFilter = c('ORAL', 'ORAL GAVAGE'),
             inclUncertain = TRUE)
# Extract animals administered oral or oral gavage.
# Do only include studies which include both route values
getSubjRoute(dbToken, controlAnimals,
             routeFilter = c('ORAL', 'ORAL GAVAGE'),
             matchAll = TRUE)
# Extract animals administered subcutaneous.
# Include only animals from studies which do not contain other route values
getSubjRoute(dbToken, controlAnimals,
             routeFilter = 'subcutaneous',
             exclusively = TRUE)
# No filtering, just add ROUTE - do not include messages when
# these values cannot be confidently found
getSubjRoute(dbToken, controlAnimals,
             noFilterReportUncertain = FALSE)
}

}
