% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_lrtp.R
\name{print.lrtp}
\alias{print.lrtp}
\title{Print an 'lrtp'- Class Object}
\usage{
\method{print}{lrtp}(
  x,
  digits = 3,
  lrtp_only = TRUE,
  wald_stats = FALSE,
  output = c("text", "data.frame", "table"),
  ...
)
}
\arguments{
\item{x}{An \code{lrtp}-class object.}

\item{digits}{Integer. The number of
decimal places to print. Default is
3.}

\item{lrtp_only}{Logical. If \code{TRUE},
the default, only parameters with
LRT \emph{p}-values will be printed.}

\item{wald_stats}{Logical. If \code{TRUE},
the usual Wald statistics (e.g.,
z statistics,
\emph{p}-values, CIs) are printed. \code{FALSE}
by default, assuming that users
prefer using LRT statistics when
using \code{\link[=lrtp]{lrtp()}}.}

\item{output}{The format of the
printout. If \code{"text"}, then the
style in the \code{\link[=summary]{summary()}}
of the \code{lavaan}-class object is used.
If \code{"data.frame"} or \code{"table"}, then the data
frame format of \code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}}
is used.}

\item{...}{Optional arguments. Not
used.}
}
\value{
\code{x} is returned invisibly.
Called for its side effect.
}
\description{
Print the content of
an \code{lrtp}-class object.
}
\details{
The print method for the
output of \code{\link[=lrtp]{lrtp()}}.

Additional diagnostic information
will be printed if one or more
likelihood tests encounter some
errors or warnings.
}
\examples{

library(lavaan)
data(data_sem16)
mod <-
"
f1 =~ x1 + x2 + x3
f2 =~ x4 + x5 + x6
"
fit <- sem(mod, data_sem16)

out <- lrtp(fit)
out
print(out, lrtp_only = FALSE)

}
\seealso{
\code{\link[=lrtp]{lrtp()}}
}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
