% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_lrt.R
\name{print.lrt}
\alias{print.lrt}
\title{Print an 'lrt'- Class Object}
\usage{
\method{print}{lrt}(x, digits = 3, ...)
}
\arguments{
\item{x}{An \code{lrt}-class object.}

\item{digits}{Integer. The number of
decimal places to print. Default is
3.}

\item{...}{Optional arguments. Not
used.}
}
\value{
\code{x} is returned invisibly.
Called for its side effect.
}
\description{
Print the content of
an \code{lrt}-class object.
}
\details{
It is the print method for
the output of \code{\link[=lrt]{lrt()}}.
}
\examples{

library(lavaan)
data(data_sem16)
mod <-
"
f1 =~ x1 + x2 + x3
f2 =~ x4 + x5 + x6
"
fit <- sem(mod, data_sem16)

out <- lrt(fit, par_id = "f1 ~~ f2")
out

}
\seealso{
\code{\link[=lrtp]{lrtp()}}
}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
