% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lrtp.R
\name{lrtp}
\alias{lrtp}
\title{Likelihood Ratio Test P-Values}
\usage{
lrtp(
  fit,
  op = c("~", "~~"),
  no_variances = TRUE,
  no_error_variances = TRUE,
  no_error_covariances = TRUE,
  se_keep_bootstrap = FALSE,
  LRT_method = "default",
  scaled.shifted = TRUE,
  fallback_method = "satorra.2000",
  progress = TRUE,
  parallel = FALSE,
  ncores = parallel::detectCores(logical = FALSE) - 1,
  load_balancing = TRUE,
  ...
)
}
\arguments{
\item{fit}{A \code{lavaan}-class object.}

\item{op}{A character vector of
\code{lavaan} model syntax operators.
Free parameters of these operators
will be included, unless excluded
by other arguments. Default is
\code{c("~", "~~")}.}

\item{no_variances}{Logical. If
\code{TRUE}, the default, then all
free variances are excluded.
(Error variances are handled
by \code{no_error_variances}.)}

\item{no_error_variances}{Logical,
If \code{TRUE}, the default, then all
free error variances are excluded.}

\item{no_error_covariances}{Logical.
If \code{TRUE}, the default, then all
free error covariances are excluded.}

\item{se_keep_bootstrap}{Logical.
If \code{TRUE} and \code{fit} used
bootstrapping standard error
(with \code{se = "bootstrap"}), bootstrapping
will also be use in fitting the
restricted model. If \code{FALSE}, the
default, then \code{se} will be set
to \code{"standard"} if it is \code{"bootstrap"}
in \code{fit}, to speed up the computation.}

\item{LRT_method}{String. Passed to
the \code{method} argument of
\code{\link[lavaan:lavTestLRT]{lavaan::lavTestLRT()}}. Default is
\code{"default"}, and let
\code{\link[lavaan:lavTestLRT]{lavaan::lavTestLRT()}} decide the
method based on \code{fit}.}

\item{scaled.shifted}{Logical.
Used when the method used in
\code{\link[lavaan:lavTestLRT]{lavaan::lavTestLRT()}} is
\code{"satorra.2000"}. Default is
\code{TRUE} and a scaled and shifted
test statistic is used, the same
default of \code{\link[lavaan:lavTestLRT]{lavaan::lavTestLRT()}}.}

\item{fallback_method}{The default
method of \code{\link[lavaan:lavTestLRT]{lavaan::lavTestLRT()}},
\code{"satorra.bentler.2001"},
may sometimes fail. If failed,
this function will call
\code{\link[lavaan:lavTestLRT]{lavaan::lavTestLRT()}}
again using \code{fallback_method}. which
is \code{"satorra.2000"} by default.}

\item{progress}{Logical. If \code{TRUE},
the default, a progress bar will be
displayed to show the progress (using
the \code{pbapply} package).}

\item{parallel}{Logical. If \code{TRUE},
parallel processing will be used to
compute the LRT \emph{p}-values for
selected parameters. Default is
\code{FALSE}. Set it to \code{TRUE} if the
number of selected parameters is
large.}

\item{ncores}{Integer. The number of
CPU cores to use if \code{parallel} is
\code{TRUE}. Default is the number of
physical cores (determined by
\code{\link[parallel:detectCores]{parallel::detectCores()}}) minus 1.}

\item{load_balancing}{Logical. If
\code{TRUE}, the default, and \code{parallel}
is \code{TRUE}, then load balancing will
be used. May shorten the total
processing time if the time to
compute LRT \emph{p}-values vary a lot
across parameters.}

\item{...}{Optional arguments to be
passed to \code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}}.}
}
\value{
An \code{lrt}-class object, which is a
data-frame-like object similar to the
output of \code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}},
with a column \code{LRTp} for the LRT
\emph{p}-values, as well as other columns
such as the chi-square difference in
the test. it has a print method,
\code{\link[=print.lrtp]{print.lrtp()}}.
}
\description{
Compute the likelihood ratio
test (LRT) \emph{p}-values for free
parameters in
a \code{lavaan} output.
}
\details{
It finds free parameters in a
\code{lavaan}-class object, computes the
likelihood ratio test (LRT) \emph{p}-value
for each of them when fixed to zero,
and returns a parameter estimates table
with the LRT \emph{p}-values
included.

By default, it only computes LRT
\emph{p}-values for regression paths
and covariances, except for
error covariances. This default
can be overridden using arguments
such as \code{op}, \code{no_variances},
\code{no_error_variances},
and \code{no_error_covariances}.
\subsection{Technical Details}{

It first identify the parameters
to be processed, and then call
\code{\link[=lrt]{lrt()}} on each of them.
Please refer to
\url{https://sfcheung.github.io/semlrtp/articles/internal_workflow.html}
for the internal workflow.
}
}
\examples{

library(lavaan)
data(data_sem16)
mod <-
"
f1 =~ x1 + x2 + x3
f2 =~ x4 + x5 + x6
f3 =~ x7 + x8 + x9
f4 =~ x10 + x11 + x12
f2 ~~ f1
f3 ~ f1 + f2
f4 ~ f3
"
fit <- sem(mod, data_sem16)
lrtp(fit)
lrtp(fit, op = "~")

}
\seealso{
\code{\link[=print.lrtp]{print.lrtp()}}
}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
