% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dates.R
\name{trim_dates}
\alias{trim_dates}
\title{Trim unknown elements in partial dates}
\usage{
trim_dates(dates, input_sep = "-")
}
\arguments{
\item{dates}{a character vector of partial dates in the format \code{"UNKN-UN-UN"}
(\code{"YYYY-MM-DD"}); full dates can also be included}

\item{input_sep}{the character that separates date components in the input
vector \code{dates}, default is \code{"-"}}
}
\value{
a character vector of trimmed partial dates and full dates
}
\description{
Removes unknown elements from a partial date. For example, \code{"2017-UN-UN"}
is trimmed to \code{"2017"} and \code{"2017-05-UN"} is trimmed to \code{"2017-05"}.
Values of \code{"UNKN-UN-UN"} are converted to \code{NA}. Values where only
the year and day are known are converted to just the year, ie \code{"2017-UN-01"}
converts to \code{"2017"}. Full dates are not modified.
}
\examples{
dates <- c(
  "UNKN-UN-UN",
  "2017-UN-UN",
  "2017-02-UN",
  "2017-UN-05",
  "2017-09-03",
  "UNKN-07-14",
  NA
)
trim_dates(dates)

}
\seealso{
\code{\link[=reshape_adates]{reshape_adates()}}, \code{\link[=reshape_pdates]{reshape_pdates()}}, \code{\link[=impute_pdates]{impute_pdates()}},
\code{vignette("Dates")}
}
