% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdtmval-package.R
\docType{package}
\name{sdtmval-package}
\alias{sdtmval}
\alias{sdtmval-package}
\title{sdtmval: Validate SDTM Domains}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Provides a set of tools to assist statistical programmers in validating Study Data Tabulation Model (SDTM) domain data sets. Statistical programmers are required to validate that a SDTM data set domain has been programmed correctly, per the SDTM Implementation Guide (SDTMIG) by 'CDISC' (\url{https://www.cdisc.org/standards/foundational/sdtmig}), study specification, and study protocol using a process called double programming. Double programming involves two different programmers independently converting the raw electronic data cut (EDC) data into a SDTM domain data table and comparing their results to ensure accurate standardization of the data. One of these attempts is termed 'production' and the other 'validation'. Generally, production runs are the official programs for submittals and these are written in 'SAS'. Validation runs can be programmed in another language, in this case 'R'.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/skgithub14/sdtmval}
  \item \url{https://skgithub14.github.io/sdtmval/}
  \item Report bugs at \url{https://github.com/skgithub14/sdtmval/issues}
}

}
\author{
\strong{Maintainer}: Stephen Knapp \email{stephen@knappconsultingllc.com} (\href{https://orcid.org/0000-0002-5101-4555}{ORCID}) [copyright holder]

}
\keyword{internal}
